/**
 * @file ConnManDbusTechnologyProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Properties for Technology.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS Properties for Technology.
 */

#ifndef _CONN_MAN_DBUS_TECHNOLOGY_PROPERTIES_H_
#define _CONN_MAN_DBUS_TECHNOLOGY_PROPERTIES_H_

#include "DbusProperties.h"
#include "ConnManDbusTypes.h"

namespace ccdbusif {
namespace connman {

/**
 * Technology properties class for ConnMan interface.
 */
class ConnManDbusTechnologyProperties : public DbusProperties
{
public:
   ConnManDbusTechnologyProperties();
   virtual ~ConnManDbusTechnologyProperties();

   TechnologyProperty getProperty2Enum(const ::std::string& value) const;
   ServiceType getType2Enum(const ::std::string& value) const;

   const ::std::string& getProperty2String(const TechnologyProperty value) const;
   const ::std::string& getProperty2StringTrace(const TechnologyProperty value) const;
   const ::std::string& getType2String(const ServiceType value) const;

private:
   const ::std::string _propertyPowered;
   const ::std::string _propertyConnected;
   const ::std::string _propertyName;
   const ::std::string _propertyType;
   const ::std::string _propertyTethering;

   const ::std::string _typeSystem;
   const ::std::string _typeEthernet;
   const ::std::string _typeWifi;
   const ::std::string _typeBluetooth;
   const ::std::string _typeCellular;
   const ::std::string _typeGps;
   const ::std::string _typeVpn;
   const ::std::string _typeGadget;

   ::std::map< std::string, int > _type2EnumList; /**< map with supported value for Type + enum pairs */
   ::std::map< int, const std::string* > _enum2TypeList; /**< map with enum + supported value for Type pairs */
};

} //connman
} //ccdbusif

#endif //_CONN_MAN_DBUS_TECHNOLOGY_PROPERTIES_H_
