/**
 * @file ConnManDbusTechnologyFactory.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan instance factory for Technology.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan instance factory for Technology.
 */

#ifndef _CONN_MAN_DBUS_TECHNOLOGY_FACTORY_H_
#define _CONN_MAN_DBUS_TECHNOLOGY_FACTORY_H_

#include "BaseInstanceFactory.h"

namespace ccdbusif {

// class forward declarations
class IConnManDbusTechnologySendRequestIf;
class ICcDbusIfControllerClient;

/**
 *
 */
class ConnManDbusTechnologyFactory : public BaseInstanceFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static ConnManDbusTechnologyFactory& getInstance(void);

   /**
    * Get proxy (pointer).
    *
    * @param[in] client: controller client
    *
    * @return = pointer to proxy
    */
   IConnManDbusTechnologySendRequestIf* getProxy(ICcDbusIfControllerClient* client);

   /**
    * Destroy proxy (pointer).
    */
   void destroyProxy(void);

   /**
    * Set proxy (pointer).
    * For testing purpose (unit test).
    * If proxy is set by external user via this interface the caller is responsible to free the proxy at the end of the test run.
    *
    * @param[in] testProxy: test version of proxy (pointer)
    */
   void setProxyForTesting(IConnManDbusTechnologySendRequestIf* testProxy);

private:
   /**
    * Default constructor. Private!!!
    */
   ConnManDbusTechnologyFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~ConnManDbusTechnologyFactory();

   IConnManDbusTechnologySendRequestIf* _proxy; /**< proxy */
};

} //ccdbusif

#endif //_CONN_MAN_DBUS_TECHNOLOGY_FACTORY_H_
