/**
 * @file ConnManDbusManagerProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Proxy for Manager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS proxy for Manager.
 */

#ifndef _CONN_MAN_DBUS_MANAGER_PROXY_IF_H_
#define _CONN_MAN_DBUS_MANAGER_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IConnManDbusManagerSendRequestIf.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "net/connman/ManagerProxy.h"

using namespace ::net::connman::Manager;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IConnManDbusManagerCallbackIf;

/**
 * Manager proxy class for ConnMan interface.
 */
class ConnManDbusManagerProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IConnManDbusManagerSendRequestIf,
   public BaseDbusProxyIf
{
public:
   ConnManDbusManagerProxyIf(ICcDbusIfControllerClient* client);
   virtual ~ConnManDbusManagerProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IConnManDbusManagerCallbackIf* callbackIf, bool enableProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IConnManDbusManagerProxyIf implementation --- start
   virtual act_t sendGetPropertiesRequest(void);

   virtual act_t sendGetTechnologiesRequest(void);

   virtual act_t sendGetServicesRequest(void);
   // IConnManDbusManagerProxyIf implementation --- end

protected:
   ConnManDbusManagerProxyIf();

private:
   ::boost::shared_ptr< ManagerProxy > _managerProxy;
   IConnManDbusManagerCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_CONN_MAN_DBUS_MANAGER_PROXY_IF_H_
