/**
 * @file DestroyProxyWorkItem.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Destroy Proxy Work Item.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation for destroy proxy work item for CcDbusIf.
 */

#include "DestroyProxyWorkItem.h"
#include "IDestroyProxy.h"

namespace ccdbusif {

DestroyProxyWorkItem::DestroyProxyWorkItem(IDestroyProxy* destroyer, const unsigned int callbackId, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/) :
_destroyer(destroyer),
_callbackId(callbackId),
_objPath(objPath),
_busName(busName),
_busType(busType)
{
}

DestroyProxyWorkItem::~DestroyProxyWorkItem()
{
   _destroyer = 0;
}

void DestroyProxyWorkItem::processWorkItem(void)
{
   if(0 != _destroyer)
   {
      _destroyer->handleDestroyProxy(_callbackId, _objPath, _busName, _busType);
   }
}

} //ccdbusif
