/**
 * @file TraceClasses.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Trace classes.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Trace classes.
 */

#ifndef _TRACE_CLASSES_H_
#define _TRACE_CLASSES_H_

// see \ai_osal_linux\components\bosch_includes\trace\mc_trace.h
// NOTE: check how to include file with TR_COMP_XXX definitions
#define TR_COMP_CONNECTIVITY  (256 * 59)
// define offset within connectivity
#define CCDBUSIF_OFFSET       0x00C8

#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

enum TrcTraceClassCCDBUSIF {
   TR_CLASS_CCDBUSIF_COMMON = TR_COMP_CONNECTIVITY + CCDBUSIF_OFFSET + 0
};

#else

#define TR_CLASS_CCDBUSIF_COMMON "CCDBUSIF___"

#endif

#endif //_TRACE_CLASSES_H_
