/**
 * @file TimeoutSemaphore.h
 *
 * @par SW-Component
 * IPC
 *
 * @brief Semaphore with timeout.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of semaphore with timeout handling.
 */

#ifndef _TIMEOUT_SEMAPHORE_H_
#define _TIMEOUT_SEMAPHORE_H_

#include <stdbool.h> // <cstdbool> is marked with C++11
#include <semaphore.h>

namespace ccdbusif {

/**
 *
 */
class TimeoutSemaphore
{
public:
   TimeoutSemaphore();
   virtual ~TimeoutSemaphore();
   void post(void);
   bool wait(const unsigned int timeoutInMs = 0);
   void tryWait(void);
   void reset(void);

private:
   sem_t _semaphore;
   bool _resetDone;

   void printSemaphoreCount(void);
};

} //ccdbusif

#endif //_TIMEOUT_SEMAPHORE_H_
