/**
 * @file SetCallbackWorkItem.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Set Callback Work Item.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Set callback work item for CcDbusIf.
 */

#ifndef _SET_CALLBACK_WORK_ITEM_H_
#define _SET_CALLBACK_WORK_ITEM_H_

#include "IWorkItem.h"
#include "ISetCallback.h"

namespace ccdbusif {

/**
 *
 */
template < class T >
class SetCallbackWorkItem : public IWorkItem
{
public:
   SetCallbackWorkItem(ISetCallback< T >* setCallback, T* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) :
   _setCallback(setCallback),
   _callbackIf(callbackIf),
   _enableProxy(enableProxy),
   _callbackId(callbackId),
   _objPath(objPath),
   _busName(busName),
   _busType(busType)
   {
   }

   virtual ~SetCallbackWorkItem()
   {
      _setCallback = 0;
      _callbackIf = 0;
   }

   virtual void processWorkItem(void)
   {
      if(0 != _setCallback)
      {
         _setCallback->handleSetCallback(_callbackIf, _enableProxy, _callbackId, _objPath, _busName, _busType);
      }
   }

private:
   ISetCallback< T >* _setCallback;
   T* _callbackIf;
   bool _enableProxy;
   unsigned int _callbackId;
   ::std::string _objPath;
   ::std::string _busName;
   DbusBusType _busType;
};

} //ccdbusif

#endif //_SET_CALLBACK_WORK_ITEM_H_
