/**
 * @file ISetCallback.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Set Callback Interface.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface for setting callback for CcDbusIf.
 */

#ifndef _I_SET_CALLBACK_H_
#define _I_SET_CALLBACK_H_

#include "CcDbusIfTypes.h"

namespace ccdbusif {

/**
 *
 */
template < class T >
class ISetCallback
{
public:
   /**
    * Destructor.
    */
   virtual ~ISetCallback() {}

   /**
    * Handle set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableProxy: flag to enable/disable proxy
    * @param[in] callbackId: callback id
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void handleSetCallback(T* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;
};

} //ccdbusif

#endif //_I_SET_CALLBACK_H_
