/**
 * @file IDestroyProxy.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Destroy Proxy.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface for destroying proxy for CcDbusIf.
 */

#ifndef _I_DESTROY_PROXY_H_
#define _I_DESTROY_PROXY_H_

#include "CcDbusIfTypes.h"

namespace ccdbusif {

/**
 *
 */
class IDestroyProxy
{
public:
   /**
    * Destructor.
    */
   virtual ~IDestroyProxy() {}

   /**
    * Handle destroy proxy request.
    *
    * @param[in] callbackId: callback id
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void handleDestroyProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;
};

} //ccdbusif

#endif //_I_DESTROY_PROXY_H_
