/**
 * @file IDestroyAllProxies.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Destroy All Proxies Interface.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface for destroy all proxies for CcDbusIf.
 */

#ifndef _I_DESTROY_ALL_PROXIES_H_
#define _I_DESTROY_ALL_PROXIES_H_

namespace ccdbusif {

/**
 *
 */
class IDestroyAllProxies
{
public:
   /**
    * Destructor.
    */
   virtual ~IDestroyAllProxies() {}

   /**
    * Handle destroy all proxies request.
    */
   virtual void handleDestroyAllProxies(void) = 0;

   /**
    * Handle destroy all runtime proxies request.
    */
   virtual void handleDestroyAllRuntimeProxies(void) = 0;
};

} //ccdbusif

#endif //_I_DESTROY_ALL_PROXIES_H_
