/**
 * @file DestroyProxyWorkItem.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Destroy Proxy Work Item.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Destroy proxy work item for CcDbusIf.
 */

#ifndef _DESTROY_PROXY_WORK_ITEM_H_
#define _DESTROY_PROXY_WORK_ITEM_H_

#include "IWorkItem.h"
#include "CcDbusIfTypes.h"

namespace ccdbusif {

// class forward declarations
class IDestroyProxy;

/**
 *
 */
class DestroyProxyWorkItem : public IWorkItem
{
public:
   DestroyProxyWorkItem(IDestroyProxy* destroyer, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual ~DestroyProxyWorkItem();

   virtual void processWorkItem(void);

private:
   IDestroyProxy* _destroyer;
   unsigned int _callbackId;
   ::std::string _objPath;
   ::std::string _busName;
   DbusBusType _busType;
};

} //ccdbusif

#endif //_DESTROY_PROXY_WORK_ITEM_H_
