/**
 * @file CreateProxyWorkItem.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Create Proxy Work Item.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Create proxy work item for CcDbusIf.
 */

#ifndef _CREATE_PROXY_WORK_ITEM_H_
#define _CREATE_PROXY_WORK_ITEM_H_

#include "IWorkItem.h"
#include "CcDbusIfTypes.h"

namespace ccdbusif {

// class forward declarations
class ICreateProxy;

/**
 *
 */
class CreateProxyWorkItem : public IWorkItem
{
public:
   CreateProxyWorkItem(ICreateProxy* creator, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual ~CreateProxyWorkItem();

   virtual void processWorkItem(void);

private:
   ICreateProxy* _creator;
   unsigned int _callbackId;
   ::std::string _objPath;
   ::std::string _busName;
   DbusBusType _busType;
};

} //ccdbusif

#endif //_CREATE_PROXY_WORK_ITEM_H_
