/**
 * @file CcDbusIfUtils.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief CcDbusIf Utilities.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Utilities for CcDbusIf.
 */

#include "CcDbusIfTypes.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>

namespace ccdbusif {

DbusBusType convertDBusBusType(const ::DBusBusType type);

::DBusBusType convertLocalBusType(const DbusBusType type);

DbusBusType convertConnectorOption2BusType(const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions);

void convertBusType2ConnectorOption(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions, const DbusBusType type);

} //ccdbusif
