/**
 * @file BaseDbusProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Base DBUS Proxy.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Base class for DBUS proxies.
 */

#ifndef _BASE_DBUS_PROXY_IF_H_
#define _BASE_DBUS_PROXY_IF_H_

#include <stdbool.h> // <cstdbool> is marked with C++11
#include <string>

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;

/**
 *
 */
class BaseDbusProxyIf
{
public:
   /**
    * Constructor.
    *
    * @param[in] client: controller client
    */
   BaseDbusProxyIf(ICcDbusIfControllerClient* client);

   /**
    * Destructor.
    */
   virtual ~BaseDbusProxyIf();

protected:
   /**
    * Default constructor.
    */
   BaseDbusProxyIf();

   bool _enableProxy; /**< enable flag */
   ICcDbusIfControllerClient* _controllerClient; /**< controller client */

   void printThreadInfo(const ::std::string& description) const;
};

} //ccdbusif

#endif //_BASE_DBUS_PROXY_IF_H_
