/**
 * @file WblWiFiSetupStatusWbl.h
 *
 * @par SW-Component
 * State machine for WBL WiFi setup status
 *
 * @brief Implementation of WBL WiFi setup status state machine.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of WBL WiFi setup status state machine.
 */

#ifndef _WBL_WIFI_SETUP_STATUS_WBL_H_
#define _WBL_WIFI_SETUP_STATUS_WBL_H_

#include "IWblWiFiSetupStatusRequest.h"
#include "IWblWiFiSetupStatusWbl.h"
#include "DbusServiceAvailability.h"

namespace btstackif {
namespace wbl {

/**
 * WBL WiFi setup status class.
 */
class WblWiFiSetupStatusWbl : public IWblWiFiSetupStatusRequest, public IWblWiFiSetupStatusWbl
{
public:
   /**
    * Default constructor.
    */
   WblWiFiSetupStatusWbl();

   /**
    * Destructor.
    */
   virtual ~WblWiFiSetupStatusWbl();

   virtual void setCallback(IN IWblWiFiSetupStatusCallback* callback);

   virtual void setControlIf(IN IBasicControl* control);

   virtual void getWifiSetupList(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual void getWifiMode(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSWblWiFiSetupId id);

   virtual void getWifiPowerState(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSWblWiFiSetupId id);

   virtual void getWifiFrequency(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSWblWiFiSetupId id);

   virtual void getAccessPointConfigType(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSWblWiFiSetupId id);

   virtual void getSupportedRestrictions(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSWblWiFiSetupId id);

   virtual void getWifiHealthinessIndicator(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSWblWiFiSetupId id);

   virtual IWblWiFiSetupStatusRequest* getRequestIf(void);

   virtual void setObjectPathManagerIf(IN IWblObjectPathManagerWbl* manager);

   virtual void handleGetManagedObjectsResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode result);

   virtual void updateServiceAvailability(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSWblDbusServiceInterface interface, IN const BTSDbusServiceAvailability availabilityEvent, IN const BTSObjectPath& objPath);

   virtual void wifiSetupEntryAdded(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& objPath);

   virtual void wifiSetupEntryRemoved(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& objPath);

   virtual void updateWifiMode(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode result, IN const BTSObjectPath& objPath, IN const BTSWblWifiMode mode);

   virtual void updateWifiPowerState(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode result, IN const BTSObjectPath& objPath, IN const BTSWblWifiPowerState powerState);

   virtual void updateWifiFrequency(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode result, IN const BTSObjectPath& objPath, IN const BTSWblWifiFrequency frequency);

   virtual void updateAccessPointConfigType(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode result, IN const BTSObjectPath& objPath, IN const BTSWblAccessPointConfigType type);

   virtual void updateSupportedRestrictions(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode result, IN const BTSObjectPath& objPath, IN const BTSWblSupportedRestrictionList& supportedRestrictions);

   virtual void updateWifiConnectionStatus(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode result, IN const BTSObjectPath& objPath, IN const bool connected, IN const BTSWblHealthinessIndicator healthIndicator);

private:
   IWblWiFiSetupStatusCallback* _callback; /**< callback interface */
   IBasicControl* _controlIf; /**< basic control interface */
   IWblObjectPathManagerWbl* _objectPathManager; /**< object path manager */
   ::std::map< BTSWblWiFiSetupId, bool > _idList; /**< id list */

   void removeId(const BTSWblWiFiSetupId id);

   bool isIdAvailable(const BTSWblWiFiSetupId id) const;

   void addId(const BTSWblWiFiSetupId id);

   void createGetManagedObjectsMsg(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList);

   void createGetWifiModeMsg(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, IN const BTSWblWiFiSetupId id, IN const BTSObjectPath& objPath);

   void createGetWifiPowerStateMsg(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, IN const BTSWblWiFiSetupId id, IN const BTSObjectPath& objPath);

   void createGetWifiFrequencyMsg(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, IN const BTSWblWiFiSetupId id, IN const BTSObjectPath& objPath);

   void createGetAccessPointConfigTypeMsg(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, IN const BTSWblWiFiSetupId id, IN const BTSObjectPath& objPath);

   void createGetSupportedFrequenciesMsg(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, IN const BTSWblWiFiSetupId id, IN const BTSObjectPath& objPath);

   void createGetWifiConnectionStatusMsg(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, IN const BTSWblWiFiSetupId id, IN const BTSObjectPath& objPath);
};

} //wbl
} //btstackif

#endif //_WBL_WIFI_SETUP_STATUS_WBL_H_
