/**
 * @file WblObjectPathManagerWbl.h
 *
 * @par SW-Component
 * State machine for WBL object path manager
 *
 * @brief Implementation of WBL object path manager state machine.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of WBL object path manager state machine.
 */

#ifndef _WBL_OBJECT_PATH_MANAGER_WBL_H_
#define _WBL_OBJECT_PATH_MANAGER_WBL_H_

#include "IWblObjectPathManagerWbl.h"
#include "DbusServiceAvailability.h"

namespace btstackif {
namespace wbl {

/**
 * WBL object path manager class.
 */
class WblObjectPathManagerWbl : public IWblObjectPathManagerWbl
{
public:
   /**
    * Default constructor.
    */
   WblObjectPathManagerWbl();

   /**
    * Destructor.
    */
   virtual ~WblObjectPathManagerWbl();

   virtual void setId2ObjectPath(IN const BTSWblWiFiSetupId id, IN const BTSObjectPath& objPath);

   virtual void removeId2ObjectPath(IN const BTSObjectPath& objPath);

   virtual bool getObjectPath4Id(OUT BTSObjectPath& objPath, IN const BTSWblWiFiSetupId id) const;

   virtual bool getId4ObjectPath(OUT BTSWblWiFiSetupId& id, IN const BTSObjectPath& objPath) const;

   virtual BTSWblWiFiSetupId getFreeId(void);

private:
   ::std::map< BTSWblWiFiSetupId, BTSObjectPath > _id2ObjectPath; /**< WiFi setup id -> object path */
   ::std::map< BTSObjectPath, BTSWblWiFiSetupId > _objectPath2Id; /**< object path -> WiFi setup id */
   ::std::vector< bool > _usedIds; /**< used WiFi setup ids */
   const BTSWblWiFiSetupId _lowerId; /**< lower WiFi setup id */
   BTSWblWiFiSetupId _nextFreeId; /**< next free WiFi setup id */

   BTSWblWiFiSetupId getNextFreeId(void);
   BTSWblWiFiSetupId getNextId(IN const BTSWblWiFiSetupId id) const;
   BTSWblWiFiSetupId getPrevId(IN const BTSWblWiFiSetupId id) const;
};

} //wbl
} //btstackif

#endif //_WBL_OBJECT_PATH_MANAGER_WBL_H_
