/**
 * @file IWblStartupWbl.h
 *
 * @par SW-Component
 * State machine for WBL startup
 *
 * @brief Interface definition for WBL startup state machine.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the WBL interface for startup state machine.
 */

#ifndef _I_WBL_STARTUP_WBL_H_
#define _I_WBL_STARTUP_WBL_H_

#include "WblStackTypes.h"

namespace btstackif {

// class forward declarations
class IWblStartupRequest;
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

namespace wbl {

/**
 * Interface definition.
 */
class IWblStartupWbl
{
public:
   /**
    * Destructor.
    */
   virtual ~IWblStartupWbl() {}

   /**
    * Get request interface.
    *
    * @return = request interface
    */
   virtual IWblStartupRequest* getRequestIf(void) = 0;

   /**
    * Add DBus interface.
    *
    * @param[out] dbusInterfaces: DBus interfaces
    */
   virtual void addInterfaces(OUT ::std::vector< BTSDbusInterfaceItem >& dbusInterfaces) = 0;

   /**
    * Update service availability.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] interface: service interface
    * @param[in] availabilityEvent: availability event
    */
   virtual void updateServiceAvailability(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSWblDbusServiceInterface interface, IN const BTSDbusServiceAvailability availabilityEvent) = 0;
};

} //wbl
} //btstackif

#endif //_I_WBL_STARTUP_WBL_H_
