/**
 * @file IWblLastModeWbl.h
 *
 * @par SW-Component
 * State machine for WBL last mode
 *
 * @brief Interface definition for WBL last mode state machine.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the WBL interface for last mode state machine.
 */

#ifndef _I_WBL_LAST_MODE_WBL_H_
#define _I_WBL_LAST_MODE_WBL_H_

#include "WblStackTypes.h"

namespace btstackif {

// class forward declarations
class IWblLastModeRequest;
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

namespace wbl {

// class forward declarations
class IWblObjectPathManagerWbl;

/**
 * Interface definition.
 */
class IWblLastModeWbl
{
public:
   /**
    * Destructor.
    */
   virtual ~IWblLastModeWbl() {}

   /**
    * Get request interface.
    *
    * @return = request interface
    */
   virtual IWblLastModeRequest* getRequestIf(void) = 0;

   /**
    * Set object path manager interface.
    *
    * @param[in] manager: object path manager interface
    */
   virtual void setObjectPathManagerIf(IN IWblObjectPathManagerWbl* manager) = 0;

   /**
    * Update last mode.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] result: result
    * @param[in] wifiSetupStatusList: wifi setup status list
    */
   virtual void updateLastMode(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode result, IN const BTSWblWiFiSetupStatusWblList& wifiSetupStatusList) = 0;
};

} //wbl
} //btstackif

#endif //_I_WBL_LAST_MODE_WBL_H_
