/**
 * @file Ipc2Bts_Wbl_WBL.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages for function block BTS_FB_WBL.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_WBL.
 */

#include "Ipc2Bts_Wbl_WBL.h"
#include "WblStackTypes.h"

namespace btstackif {
namespace wbl {

Ipc2Bts_ServiceAvailabilityWbl::Ipc2Bts_ServiceAvailabilityWbl()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Ipc2BtsOC_ServiceAvailabilityWbl))
{
   _interface = BTS_WBL_DBUS_SERVICE_LAST;
   _availabilityEvent = BTS_DBUS_SERVICE_LAST;
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_WBL);
}

Ipc2Bts_ServiceAvailabilityWbl::Ipc2Bts_ServiceAvailabilityWbl(IN const Ipc2Bts_ServiceAvailabilityWbl& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _interface = ref._interface;
   _availabilityEvent = ref._availabilityEvent;
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Ipc2Bts_ServiceAvailabilityWbl& Ipc2Bts_ServiceAvailabilityWbl::operator=(IN const Ipc2Bts_ServiceAvailabilityWbl& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _interface = ref._interface;
   _availabilityEvent = ref._availabilityEvent;
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_ServiceAvailabilityWbl::~Ipc2Bts_ServiceAvailabilityWbl()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ServiceAvailabilityWbl::clone(void) const
{
   return new Ipc2Bts_ServiceAvailabilityWbl(*this);
}

Ipc2Bts_GetManagedObjectsWbl::Ipc2Bts_GetManagedObjectsWbl()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Ipc2BtsOC_GetManagedObjectsWbl))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_WBL);
}

Ipc2Bts_GetManagedObjectsWbl::Ipc2Bts_GetManagedObjectsWbl(IN const Ipc2Bts_GetManagedObjectsWbl& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Ipc2Bts_GetManagedObjectsWbl& Ipc2Bts_GetManagedObjectsWbl::operator=(IN const Ipc2Bts_GetManagedObjectsWbl& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_GetManagedObjectsWbl::~Ipc2Bts_GetManagedObjectsWbl()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GetManagedObjectsWbl::clone(void) const
{
   return new Ipc2Bts_GetManagedObjectsWbl(*this);
}

Ipc2Bts_AddWifiSetupObjectPath::Ipc2Bts_AddWifiSetupObjectPath()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Ipc2BtsOC_AddWifiSetupObjectPath))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_WBL);
}

Ipc2Bts_AddWifiSetupObjectPath::Ipc2Bts_AddWifiSetupObjectPath(IN const Ipc2Bts_AddWifiSetupObjectPath& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_AddWifiSetupObjectPath& Ipc2Bts_AddWifiSetupObjectPath::operator=(IN const Ipc2Bts_AddWifiSetupObjectPath& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_AddWifiSetupObjectPath::~Ipc2Bts_AddWifiSetupObjectPath()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AddWifiSetupObjectPath::clone(void) const
{
   return new Ipc2Bts_AddWifiSetupObjectPath(*this);
}

Ipc2Bts_DelWifiSetupObjectPath::Ipc2Bts_DelWifiSetupObjectPath()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Ipc2BtsOC_DelWifiSetupObjectPath))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_WBL);
}

Ipc2Bts_DelWifiSetupObjectPath::Ipc2Bts_DelWifiSetupObjectPath(IN const Ipc2Bts_DelWifiSetupObjectPath& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_DelWifiSetupObjectPath& Ipc2Bts_DelWifiSetupObjectPath::operator=(IN const Ipc2Bts_DelWifiSetupObjectPath& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_DelWifiSetupObjectPath::~Ipc2Bts_DelWifiSetupObjectPath()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DelWifiSetupObjectPath::clone(void) const
{
   return new Ipc2Bts_DelWifiSetupObjectPath(*this);
}

Ipc2Bts_LastIntendedModeUpdate::Ipc2Bts_LastIntendedModeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Ipc2BtsOC_LastIntendedModeUpdate))
{
   // _wifiSetupStatusList is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_WBL);
}

Ipc2Bts_LastIntendedModeUpdate::Ipc2Bts_LastIntendedModeUpdate(IN const Ipc2Bts_LastIntendedModeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _wifiSetupStatusList = ref._wifiSetupStatusList;
}

Ipc2Bts_LastIntendedModeUpdate& Ipc2Bts_LastIntendedModeUpdate::operator=(IN const Ipc2Bts_LastIntendedModeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _wifiSetupStatusList = ref._wifiSetupStatusList;

   return *this;
}

Ipc2Bts_LastIntendedModeUpdate::~Ipc2Bts_LastIntendedModeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LastIntendedModeUpdate::clone(void) const
{
   return new Ipc2Bts_LastIntendedModeUpdate(*this);
}

Ipc2Bts_SupportedFrequenciesUpdate::Ipc2Bts_SupportedFrequenciesUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Ipc2BtsOC_SupportedFrequenciesUpdate))
{
   // _objPath: init is done by member constructor
   // _supportedRestrictions is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_WBL);
}

Ipc2Bts_SupportedFrequenciesUpdate::Ipc2Bts_SupportedFrequenciesUpdate(IN const Ipc2Bts_SupportedFrequenciesUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
   _supportedRestrictions = ref._supportedRestrictions;
}

Ipc2Bts_SupportedFrequenciesUpdate& Ipc2Bts_SupportedFrequenciesUpdate::operator=(IN const Ipc2Bts_SupportedFrequenciesUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;
   _supportedRestrictions = ref._supportedRestrictions;

   return *this;
}

Ipc2Bts_SupportedFrequenciesUpdate::~Ipc2Bts_SupportedFrequenciesUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_SupportedFrequenciesUpdate::clone(void) const
{
   return new Ipc2Bts_SupportedFrequenciesUpdate(*this);
}

Ipc2Bts_WifiModeUpdate::Ipc2Bts_WifiModeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Ipc2BtsOC_WifiModeUpdate))
{
   _mode = BTS_WBL_WIFI_MODE_LAST;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_WBL);
}

Ipc2Bts_WifiModeUpdate::Ipc2Bts_WifiModeUpdate(IN const Ipc2Bts_WifiModeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _mode = ref._mode;
   _objPath = ref._objPath;
}

Ipc2Bts_WifiModeUpdate& Ipc2Bts_WifiModeUpdate::operator=(IN const Ipc2Bts_WifiModeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _mode = ref._mode;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_WifiModeUpdate::~Ipc2Bts_WifiModeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_WifiModeUpdate::clone(void) const
{
   return new Ipc2Bts_WifiModeUpdate(*this);
}

Ipc2Bts_WifiPowerStateUpdate::Ipc2Bts_WifiPowerStateUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Ipc2BtsOC_WifiPowerStateUpdate))
{
   _powerState = BTS_WBL_WIFI_STATE_LAST;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_WBL);
}

Ipc2Bts_WifiPowerStateUpdate::Ipc2Bts_WifiPowerStateUpdate(IN const Ipc2Bts_WifiPowerStateUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _powerState = ref._powerState;
   _objPath = ref._objPath;
}

Ipc2Bts_WifiPowerStateUpdate& Ipc2Bts_WifiPowerStateUpdate::operator=(IN const Ipc2Bts_WifiPowerStateUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _powerState = ref._powerState;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_WifiPowerStateUpdate::~Ipc2Bts_WifiPowerStateUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_WifiPowerStateUpdate::clone(void) const
{
   return new Ipc2Bts_WifiPowerStateUpdate(*this);
}

Ipc2Bts_WifiFrequencyUpdate::Ipc2Bts_WifiFrequencyUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Ipc2BtsOC_WifiFrequencyUpdate))
{
   _frequency = BTS_WBL_WIFI_FREQUENCY_LAST;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_WBL);
}

Ipc2Bts_WifiFrequencyUpdate::Ipc2Bts_WifiFrequencyUpdate(IN const Ipc2Bts_WifiFrequencyUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _frequency = ref._frequency;
   _objPath = ref._objPath;
}

Ipc2Bts_WifiFrequencyUpdate& Ipc2Bts_WifiFrequencyUpdate::operator=(IN const Ipc2Bts_WifiFrequencyUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _frequency = ref._frequency;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_WifiFrequencyUpdate::~Ipc2Bts_WifiFrequencyUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_WifiFrequencyUpdate::clone(void) const
{
   return new Ipc2Bts_WifiFrequencyUpdate(*this);
}

Ipc2Bts_AccessPointConfigTypeUpdate::Ipc2Bts_AccessPointConfigTypeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Ipc2BtsOC_AccessPointConfigTypeUpdate))
{
   _type = BTS_WBL_AP_CONFIG_LAST;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_WBL);
}

Ipc2Bts_AccessPointConfigTypeUpdate::Ipc2Bts_AccessPointConfigTypeUpdate(IN const Ipc2Bts_AccessPointConfigTypeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _type = ref._type;
   _objPath = ref._objPath;
}

Ipc2Bts_AccessPointConfigTypeUpdate& Ipc2Bts_AccessPointConfigTypeUpdate::operator=(IN const Ipc2Bts_AccessPointConfigTypeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _type = ref._type;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_AccessPointConfigTypeUpdate::~Ipc2Bts_AccessPointConfigTypeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AccessPointConfigTypeUpdate::clone(void) const
{
   return new Ipc2Bts_AccessPointConfigTypeUpdate(*this);
}

Ipc2Bts_WifiConnectionStatusUpdate::Ipc2Bts_WifiConnectionStatusUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Ipc2BtsOC_WifiConnectionStatusUpdate))
{
   _connected = false;
   _healthIndicator = 0;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_WBL);
}

Ipc2Bts_WifiConnectionStatusUpdate::Ipc2Bts_WifiConnectionStatusUpdate(IN const Ipc2Bts_WifiConnectionStatusUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _connected = ref._connected;
   _healthIndicator = ref._healthIndicator;
   _objPath = ref._objPath;
}

Ipc2Bts_WifiConnectionStatusUpdate& Ipc2Bts_WifiConnectionStatusUpdate::operator=(IN const Ipc2Bts_WifiConnectionStatusUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _connected = ref._connected;
   _healthIndicator = ref._healthIndicator;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_WifiConnectionStatusUpdate::~Ipc2Bts_WifiConnectionStatusUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_WifiConnectionStatusUpdate::clone(void) const
{
   return new Ipc2Bts_WifiConnectionStatusUpdate(*this);
}

} //wbl
} //btstackif
