/**
 * @file Ipc2Bts_Wbl_WBL.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages for function block BTS_FB_WBL.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_WBL.
 */

#ifndef _IPC_2_BTS_WBL_MSG_WBL_H_
#define _IPC_2_BTS_WBL_MSG_WBL_H_

#include "WblStackTypes.h"
#include "Ipc2Bts_BaseMessage.h"

namespace btstackif {
namespace wbl {

/**
 *
 */
class Ipc2Bts_ServiceAvailabilityWbl : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ServiceAvailabilityWbl();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ServiceAvailabilityWbl(IN const Ipc2Bts_ServiceAvailabilityWbl& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ServiceAvailabilityWbl& operator=(IN const Ipc2Bts_ServiceAvailabilityWbl& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ServiceAvailabilityWbl();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInterface(IN const BTSWblDbusServiceInterface interface) { _interface = interface; }
   inline void setAvailabilityEvent(IN const BTSDbusServiceAvailability availabilityEvent) { _availabilityEvent = availabilityEvent; }
   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSWblDbusServiceInterface getInterface(void) const { return _interface; }
   inline BTSDbusServiceAvailability getAvailabilityEvent(void) const { return _availabilityEvent; }
   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSWblDbusServiceInterface _interface; /**< parameter interface */
   BTSDbusServiceAvailability _availabilityEvent; /**< parameter availability event */
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_GetManagedObjectsWbl : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GetManagedObjectsWbl();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GetManagedObjectsWbl(IN const Ipc2Bts_GetManagedObjectsWbl& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GetManagedObjectsWbl& operator=(IN const Ipc2Bts_GetManagedObjectsWbl& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GetManagedObjectsWbl();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_AddWifiSetupObjectPath : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AddWifiSetupObjectPath();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AddWifiSetupObjectPath(IN const Ipc2Bts_AddWifiSetupObjectPath& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AddWifiSetupObjectPath& operator=(IN const Ipc2Bts_AddWifiSetupObjectPath& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AddWifiSetupObjectPath();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_DelWifiSetupObjectPath : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DelWifiSetupObjectPath();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DelWifiSetupObjectPath(IN const Ipc2Bts_DelWifiSetupObjectPath& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DelWifiSetupObjectPath& operator=(IN const Ipc2Bts_DelWifiSetupObjectPath& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DelWifiSetupObjectPath();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_LastIntendedModeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LastIntendedModeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LastIntendedModeUpdate(IN const Ipc2Bts_LastIntendedModeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LastIntendedModeUpdate& operator=(IN const Ipc2Bts_LastIntendedModeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LastIntendedModeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setWifiSetupStatusList(IN const BTSWblWiFiSetupStatusWblList& wifiSetupStatusList) { _wifiSetupStatusList = wifiSetupStatusList; }

   inline void getWifiSetupStatusList(OUT BTSWblWiFiSetupStatusWblList& wifiSetupStatusList) const { wifiSetupStatusList = _wifiSetupStatusList; }
   inline const BTSWblWiFiSetupStatusWblList& getWifiSetupStatusList(void) const { return _wifiSetupStatusList; }
   inline BTSWblWiFiSetupStatusWblList& getWifiSetupStatusListMutable(void) { return _wifiSetupStatusList; }

private:
   BTSWblWiFiSetupStatusWblList _wifiSetupStatusList; /**< parameter wifi setup status list */
};

/**
 *
 */
class Ipc2Bts_SupportedFrequenciesUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_SupportedFrequenciesUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_SupportedFrequenciesUpdate(IN const Ipc2Bts_SupportedFrequenciesUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_SupportedFrequenciesUpdate& operator=(IN const Ipc2Bts_SupportedFrequenciesUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_SupportedFrequenciesUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }
   inline void setSupportedRestrictions(IN const BTSWblSupportedRestrictionList& supportedRestrictions) { _supportedRestrictions = supportedRestrictions; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }
   inline void getSupportedRestrictions(OUT BTSWblSupportedRestrictionList& supportedRestrictions) const { supportedRestrictions = _supportedRestrictions; }
   inline const BTSWblSupportedRestrictionList& getSupportedRestrictions(void) const { return _supportedRestrictions; }
   inline BTSWblSupportedRestrictionList& getSupportedRestrictionsMutable(void) { return _supportedRestrictions; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
   BTSWblSupportedRestrictionList _supportedRestrictions; /**< parameter supported restrictions */
};

/**
 *
 */
class Ipc2Bts_WifiModeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_WifiModeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_WifiModeUpdate(IN const Ipc2Bts_WifiModeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_WifiModeUpdate& operator=(IN const Ipc2Bts_WifiModeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_WifiModeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setMode(IN const BTSWblWifiMode mode) { _mode = mode; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSWblWifiMode getMode(void) const { return _mode; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSWblWifiMode _mode; /**< parameter mode */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_WifiPowerStateUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_WifiPowerStateUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_WifiPowerStateUpdate(IN const Ipc2Bts_WifiPowerStateUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_WifiPowerStateUpdate& operator=(IN const Ipc2Bts_WifiPowerStateUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_WifiPowerStateUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setPowerState(IN const BTSWblWifiPowerState powerState) { _powerState = powerState; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSWblWifiPowerState getPowerState(void) const { return _powerState; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSWblWifiPowerState _powerState; /**< parameter power state */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_WifiFrequencyUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_WifiFrequencyUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_WifiFrequencyUpdate(IN const Ipc2Bts_WifiFrequencyUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_WifiFrequencyUpdate& operator=(IN const Ipc2Bts_WifiFrequencyUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_WifiFrequencyUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setFrequency(IN const BTSWblWifiFrequency frequency) { _frequency = frequency; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSWblWifiFrequency getFrequency(void) const { return _frequency; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSWblWifiFrequency _frequency; /**< parameter frequency */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_AccessPointConfigTypeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AccessPointConfigTypeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AccessPointConfigTypeUpdate(IN const Ipc2Bts_AccessPointConfigTypeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AccessPointConfigTypeUpdate& operator=(IN const Ipc2Bts_AccessPointConfigTypeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AccessPointConfigTypeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setType(IN const BTSWblAccessPointConfigType type) { _type = type; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSWblAccessPointConfigType getType(void) const { return _type; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSWblAccessPointConfigType _type; /**< parameter type */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_WifiConnectionStatusUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_WifiConnectionStatusUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_WifiConnectionStatusUpdate(IN const Ipc2Bts_WifiConnectionStatusUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_WifiConnectionStatusUpdate& operator=(IN const Ipc2Bts_WifiConnectionStatusUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_WifiConnectionStatusUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setConnected(IN const bool connected) { _connected = connected; }
   inline void setHealthIndicator(IN const BTSWblHealthinessIndicator healthIndicator) { _healthIndicator = healthIndicator; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline bool getConnected(void) const { return _connected; }
   inline BTSWblHealthinessIndicator getHealthIndicator(void) const { return _healthIndicator; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   bool _connected; /**< parameter connected */
   BTSWblHealthinessIndicator _healthIndicator; /**< parameter health indicator */
   BTSObjectPath _objPath; /**< parameter obj path */
};

} //wbl
} //btstackif

#endif //_IPC_2_BTS_WBL_MSG_WBL_H_
