/**
 * @file Ipc2Bts_MessageWrapper_WBL.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief Wrapper for IPC to BtStackIf messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wrapper for IPC to BtStackIf messages.
 * The only reason for this file is to solve following lint warnings:
 * Warning 429: prio2: Custodial pointer 'ptrMessage' ...
 */

#ifndef _IPC_2_BTS_MESSAGE_WRAPPER_WBL_H_
#define _IPC_2_BTS_MESSAGE_WRAPPER_WBL_H_

#include "Ipc2Bts_Wbl_WBL.h"

namespace btstackif {
namespace wbl {

inline Ipc2Bts_ServiceAvailabilityWbl* ptrNew_Ipc2Bts_ServiceAvailabilityWbl(void) { return new Ipc2Bts_ServiceAvailabilityWbl(); }
inline Ipc2Bts_GetManagedObjectsWbl* ptrNew_Ipc2Bts_GetManagedObjectsWbl(void) { return new Ipc2Bts_GetManagedObjectsWbl(); }
inline Ipc2Bts_AddWifiSetupObjectPath* ptrNew_Ipc2Bts_AddWifiSetupObjectPath(void) { return new Ipc2Bts_AddWifiSetupObjectPath(); }
inline Ipc2Bts_DelWifiSetupObjectPath* ptrNew_Ipc2Bts_DelWifiSetupObjectPath(void) { return new Ipc2Bts_DelWifiSetupObjectPath(); }
inline Ipc2Bts_LastIntendedModeUpdate* ptrNew_Ipc2Bts_LastIntendedModeUpdate(void) { return new Ipc2Bts_LastIntendedModeUpdate(); }
inline Ipc2Bts_SupportedFrequenciesUpdate* ptrNew_Ipc2Bts_SupportedFrequenciesUpdate(void) { return new Ipc2Bts_SupportedFrequenciesUpdate(); }
inline Ipc2Bts_WifiModeUpdate* ptrNew_Ipc2Bts_WifiModeUpdate(void) { return new Ipc2Bts_WifiModeUpdate(); }
inline Ipc2Bts_WifiPowerStateUpdate* ptrNew_Ipc2Bts_WifiPowerStateUpdate(void) { return new Ipc2Bts_WifiPowerStateUpdate(); }
inline Ipc2Bts_WifiFrequencyUpdate* ptrNew_Ipc2Bts_WifiFrequencyUpdate(void) { return new Ipc2Bts_WifiFrequencyUpdate(); }
inline Ipc2Bts_AccessPointConfigTypeUpdate* ptrNew_Ipc2Bts_AccessPointConfigTypeUpdate(void) { return new Ipc2Bts_AccessPointConfigTypeUpdate(); }
inline Ipc2Bts_WifiConnectionStatusUpdate* ptrNew_Ipc2Bts_WifiConnectionStatusUpdate(void) { return new Ipc2Bts_WifiConnectionStatusUpdate(); }

} //wbl
} //btstackif

#endif //_IPC_2_BTS_MESSAGE_WRAPPER_WBL_H_
