/**
 * @file WblOrgFreedesktopObjectManagerFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief OrgFreedesktop instance factory for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details OrgFreedesktop instance factory for ObjectManager.
 */

#include "WblOrgFreedesktopObjectManagerFactory.h"
#include "WblOrgFreedesktopObjectManagerCallbackIf.h"

namespace btstackif {
namespace wbl {

WblOrgFreedesktopObjectManagerFactory::WblOrgFreedesktopObjectManagerFactory() :
_createdLocally(true),
_cb(0)
{
}

WblOrgFreedesktopObjectManagerFactory::~WblOrgFreedesktopObjectManagerFactory()
{
   _cb = 0;
}

WblOrgFreedesktopObjectManagerFactory& WblOrgFreedesktopObjectManagerFactory::getInstance(void)
{
   static WblOrgFreedesktopObjectManagerFactory factory;
   return factory;
}

IWblOrgFreedesktopObjectManagerCallbackIf* WblOrgFreedesktopObjectManagerFactory::getCb(IDbusRecHandler* handler)
{
   if(0 != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new WblOrgFreedesktopObjectManagerCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void WblOrgFreedesktopObjectManagerFactory::destroyCb(void)
{
   if((0 != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = 0;
   }
}

void WblOrgFreedesktopObjectManagerFactory::setCbForTesting(IWblOrgFreedesktopObjectManagerCallbackIf* testCallback)
{
   if(0 != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //wbl
} //btstackif
