/**
 * @file WblLastIntendedModeFactory.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief Wbl instance factory for LastIntendedMode.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl instance factory for LastIntendedMode.
 */

#ifndef _WBL_LAST_INTENDED_MODE_FACTORY_H_
#define _WBL_LAST_INTENDED_MODE_FACTORY_H_

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace wbl {

// class forward declarations
class IWblLastIntendedModeCallbackIf;

/**
 * Factory class for WblLastIntendedMode.
 */
class WblLastIntendedModeFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static WblLastIntendedModeFactory& getInstance(void);

   /**
    * Get callback instance (pointer).
    *
    * @param[in] handler: receive handler
    *
    * @return = pointer to callback instance
    */
   IWblLastIntendedModeCallbackIf* getCb(IDbusRecHandler* handler);

   /**
    * Destroy callback instance (pointer).
    */
   void destroyCb(void);

   /**
    * Set callback instance (pointer).
    * For testing purpose (unit test).
    * If callback instance is set by external user via this interface the caller is responsible to free the callback instance at the end of the test run.
    *
    * @param[in] testCallback: test version of callback instance (pointer)
    */
   void setCbForTesting(IWblLastIntendedModeCallbackIf* testCallback);

private:
   /**
    * Default constructor. Private!!!
    */
   WblLastIntendedModeFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~WblLastIntendedModeFactory();

   bool _createdLocally; /**< creator flag */
   IWblLastIntendedModeCallbackIf* _cb; /**< callback instance */
};

} //wbl
} //btstackif

#endif //_WBL_LAST_INTENDED_MODE_FACTORY_H_
