/**
 * @file WblDbusIfHandler.h
 *
 * @par SW-Component
 * IPC
 *
 * @brief DBUS WBL handling.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Class for DBUS WBL handling.
 */

#ifndef _WBL_DBUS_IF_HANDLER_H_
#define _WBL_DBUS_IF_HANDLER_H_

#include "WblStackTypes.h"
#include "IDbusIfHandler.h"

// class forward declarations
namespace ccdbusif {
class IWblDbusLastIntendedModeSendRequestIf;
class IWblDbusConflictManagementSendRequestIf;
class IWblDbusWifiSetupSendRequestIf;
class IOrgFreedesktopDbusObjectManagerSendRequestIf;
} //ccdbusif

namespace btstackif {
namespace wbl {

// class forward declarations
class IWblLastIntendedModeCallbackIf;
class IWblConflictManagementCallbackIf;
class IWblWifiSetupCallbackIf;
class IWblOrgFreedesktopObjectManagerCallbackIf;

// Bts2Ipc messages
class Bts2Ipc_GetManagedObjectsWbl;
class Bts2Ipc_GetIntrospectionWbl;
class Bts2Ipc_GetLastIntendedMode;
class Bts2Ipc_GetSupportedFrequencies;
class Bts2Ipc_GetWifiMode;
class Bts2Ipc_GetWifiPowerState;
class Bts2Ipc_GetWifiFrequency;
class Bts2Ipc_GetAccessPointConfigType;
class Bts2Ipc_GetWifiConnectionStatus;

/**
 *
 */
class WblDbusIfHandler : public IDbusIfHandler
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    *
    * @param[in] component: component
    * @param[in] stackInterface: stack interface
    * @param[in] subComponent: sub component
    */
   WblDbusIfHandler(IN const BTSFunctionBlock component, IN const BTSInterfaceType stackInterface, IN const BTSFunctionBlock subComponent);

   /**
    * Destructor.
    */
   virtual ~WblDbusIfHandler();

   virtual void setDbusBaseIf(IN IDbusBase* dbusBase);

   virtual void setDbusRecHandlerIf(IN IDbusRecHandler* dbusRecHandler);

   virtual void enable(IN const bool enable);

   virtual void initialize(void);

   virtual void destroy(void);

   virtual void setCcDbusIfControllerIf(IN const BTSFunctionBlock component, IN const BTSInterfaceType stackInterface, IN const BTSFunctionBlock subComponent, IN const BTSUserMode userMode,
            IN ::ccdbusif::ICcDbusIfController* controller, IN const ::std::vector< BTSDbusInterfaceItem >& dbusInterfaces, IN const BTSLocalConfigurationContainer& configuration);

   virtual void resetCcDbusIfControllerIf(void);

   virtual bool setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData);

   virtual bool setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData);

   virtual bool setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData);

   virtual bool sendMessage(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_BaseMessage* message);

   virtual bool createErrorMessage(OUT Ipc2Bts_BaseMessage** ipc2BtsMessage, IN const Bts2Ipc_BaseMessage* bts2IpcMessage, IN const BTSIpcCommonErrorCode errorCode) const;

   virtual bool transferMessageData(OUT Ipc2Bts_BaseMessage* ipc2BtsMessage, IN const Bts2Ipc_BaseMessage* bts2IpcMessage) const;

private:
   const BTSFunctionBlock _component; /**< component (function) block => tracing only */
   const BTSInterfaceType _stackInterface; /**< sub-component (function) block => tracing only */
   const BTSFunctionBlock _subComponent; /**< stack interface to be used => tracing only */
   const BTSTimeValue _getUpdateTimeout; /**< timeout value in ms for receiving update message for a get request */
   IDbusBase* _dbusBaseIf; /**< DBus base interface */
   IDbusRecHandler* _dbusRecHandler; /**< DBus receive handler */

   ::ccdbusif::IWblDbusLastIntendedModeSendRequestIf* _lastIntendedModeIf; /**< send interface */
   ::ccdbusif::IWblDbusConflictManagementSendRequestIf* _conflictManagementIf; /**< send interface */
   ::ccdbusif::IWblDbusWifiSetupSendRequestIf* _wifiSetupIf; /**< send interface */
   ::ccdbusif::IOrgFreedesktopDbusObjectManagerSendRequestIf* _objMgrIf; /**< send interface */

   IWblLastIntendedModeCallbackIf* _lastIntendedModeCb; /**< callback interface */
   IWblConflictManagementCallbackIf* _conflictManagementCb; /**< callback interface */
   IWblWifiSetupCallbackIf* _wifiSetupCb; /**< callback interface */
   IWblOrgFreedesktopObjectManagerCallbackIf* _objMgrCb; /**< callback interface */

   // Bts2Ipc message handler
   void handleBts2IpcGetManagedObjectsWbl(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetManagedObjectsWbl& message);
   void handleBts2IpcGetIntrospectionWbl(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetIntrospectionWbl& message);
   void handleBts2IpcGetLastIntendedMode(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetLastIntendedMode& message);
   void handleBts2IpcGetSupportedFrequencies(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetSupportedFrequencies& message);
   void handleBts2IpcGetWifiMode(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetWifiMode& message);
   void handleBts2IpcGetWifiPowerState(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetWifiPowerState& message);
   void handleBts2IpcGetWifiFrequency(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetWifiFrequency& message);
   void handleBts2IpcGetAccessPointConfigType(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetAccessPointConfigType& message);
   void handleBts2IpcGetWifiConnectionStatus(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetWifiConnectionStatus& message);
};

} //wbl
} //btstackif

#endif //_WBL_DBUS_IF_HANDLER_H_
