/**
 * @file IWblLastIntendedModeCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief Wbl DBUS Callback Interface for LastIntendedMode.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for Wbl DBUS callback for LastIntendedMode.
 */

#ifndef _I_WBL_LAST_INTENDED_MODE_CALLBACK_IF_H_
#define _I_WBL_LAST_INTENDED_MODE_CALLBACK_IF_H_

#include "cc_dbus_if/IWblDbusLastIntendedModeCallbackIf.h"

using namespace ::org::bosch::wbl::LastIntendedMode;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace wbl {

/**
 * Callback interface class for LastIntendedMode.
 */
class IWblLastIntendedModeCallbackIf : public ::ccdbusif::IWblDbusLastIntendedModeCallbackIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IWblLastIntendedModeCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM) = 0;

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM) = 0;
   // "ServiceAvailableIF" implementation --- end

   // /org/bosch/wbl/LastIntendedModeProxy implementation --- start
   virtual void onLastIntendedModeErrorCb(const ::boost::shared_ptr< LastIntendedModeError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onLastIntendedModeUpdateCb(const ::boost::shared_ptr< LastIntendedModeUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;
   // /org/bosch/wbl/LastIntendedModeProxy implementation --- end

   /**
    * Set receive handler.
    *
    * @param[in] handler: receive handler
    */
   virtual void setReceiveHandler(IDbusRecHandler* handler) = 0;

   /**
    * Set callback id.
    *
    * @param[in] callbackId: callback id
    */
   virtual void setCallbackId(const unsigned int callbackId) = 0;

   /**
    * Get callback id.
    *
    * @return = callback id
    */
   virtual unsigned int getCallbackId(void) const = 0;
};

} //wbl
} //btstackif

#endif //_I_WBL_LAST_INTENDED_MODE_CALLBACK_IF_H_
