/**
 * @file IWblConflictManagementCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief Wbl DBUS Callback Interface for ConflictManagement.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for Wbl DBUS callback for ConflictManagement.
 */

#ifndef _I_WBL_CONFLICT_MANAGEMENT_CALLBACK_IF_H_
#define _I_WBL_CONFLICT_MANAGEMENT_CALLBACK_IF_H_

#include "cc_dbus_if/IWblDbusConflictManagementCallbackIf.h"

using namespace ::org::bosch::wbl::conflictmanagement;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace wbl {

/**
 * Callback interface class for ConflictManagement.
 */
class IWblConflictManagementCallbackIf : public ::ccdbusif::IWblDbusConflictManagementCallbackIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IWblConflictManagementCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM) = 0;

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM) = 0;
   // "ServiceAvailableIF" implementation --- end

   // /org/bosch/wbl/conflictmanagementProxy implementation --- start
   virtual void onPrepareSetupErrorCb(const ::boost::shared_ptr< PrepareSetupError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onPrepareSetupResponseCb(const ::boost::shared_ptr< PrepareSetupResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onDeActivateSetupErrorCb(const ::boost::shared_ptr< DeActivateSetupError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onDeActivateSetupResponseCb(const ::boost::shared_ptr< DeActivateSetupResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onWiFiStationModeUsageErrorCb(const ::boost::shared_ptr< WiFiStationModeUsageError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onWiFiStationModeUsageResponseCb(const ::boost::shared_ptr< WiFiStationModeUsageResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onResolveConflictErrorCb(const ::boost::shared_ptr< ResolveConflictError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onResolveConflictResponseCb(const ::boost::shared_ptr< ResolveConflictResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onConflictDetectedErrorCb(const ::boost::shared_ptr< ConflictDetectedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onConflictDetectedSignalCb(const ::boost::shared_ptr< ConflictDetectedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onConflictResolvedErrorCb(const ::boost::shared_ptr< ConflictResolvedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onConflictResolvedSignalCb(const ::boost::shared_ptr< ConflictResolvedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onActiveWiFiSetupsErrorCb(const ::boost::shared_ptr< ActiveWiFiSetupsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onActiveWiFiSetupsUpdateCb(const ::boost::shared_ptr< ActiveWiFiSetupsUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onWiFiPriorityListErrorCb(const ::boost::shared_ptr< WiFiPriorityListError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onWiFiPriorityListUpdateCb(const ::boost::shared_ptr< WiFiPriorityListUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onConfigurationTimerErrorCb(const ::boost::shared_ptr< ConfigurationTimerError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onConfigurationTimerUpdateCb(const ::boost::shared_ptr< ConfigurationTimerUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;
   // /org/bosch/wbl/conflictmanagementProxy implementation --- end

   /**
    * Set receive handler.
    *
    * @param[in] handler: receive handler
    */
   virtual void setReceiveHandler(IDbusRecHandler* handler) = 0;

   /**
    * Set callback id.
    *
    * @param[in] callbackId: callback id
    */
   virtual void setCallbackId(const unsigned int callbackId) = 0;

   /**
    * Get callback id.
    *
    * @return = callback id
    */
   virtual unsigned int getCallbackId(void) const = 0;
};

} //wbl
} //btstackif

#endif //_I_WBL_CONFLICT_MANAGEMENT_CALLBACK_IF_H_
