/**
 * @file WblControlMain.h
 *
 * @par SW-Component
 * Main
 *
 * @brief WBL Control Main.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Class for WBL control main functionality.
 */

#ifndef _WBL_CONTROL_MAIN_H_
#define _WBL_CONTROL_MAIN_H_

#include "BtStackInternalTypes.h"
#include "BasicControl.h"

namespace btstackif {
namespace wbl {

/**
 *
 */
class WblControlMain : public BasicControl
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   WblControlMain();

   /**
    * Destructor.
    */
   virtual ~WblControlMain();

   virtual void pushApp2BtsMessage(IN App2Bts_BaseMessage* ptrMessage);

   virtual void pushIpc2BtsMessage(IN Ipc2Bts_BaseMessage* ptrMessage);

   virtual void setStackConfiguration(IN const BTSFunctionBlock component, IN const BTSInterfaceType stackInterface, IN const BTSFunctionBlock subComponent, IN const BTSUserMode userMode,
         OUT ::std::vector< BTSDbusInterfaceItem >& dbusInterfaces, IN const BTSLocalConfigurationContainer& configuration);

   virtual void triggerInitializedCallback(void);

   virtual void createDbusServiceAvailabilityMessage(IN const BTSCommonEnumClass interface, IN const BTSDbusServiceAvailability availabilityEvent);

   virtual void createDbusServiceAvailabilityMessage(IN const BTSCommonEnumClass interface, IN const BTSDbusServiceAvailability availabilityEvent, IN const BTSBusName& busName, IN const BTSObjectPath& objPath, IN const BTSCommonEnumClass busType);

   virtual void handleTimeout(IN IExtendedTimeoutHandler* handler, IN const BTSTimerId timerId);

   virtual void setSubControlTestCommand(IN const char* testCommand, IN const unsigned int testData);

   virtual void setSubControlTestCommand(IN const char* testCommand, IN const unsigned char* testData);

   virtual void sendDirectAnswerForApp2BtsMessages(IN const ::std::vector< App2Bts_BaseMessage* >& msgList, IN const BTSCommonEnumClass resultCode, IN const BTSCommonEnumClass statusCode);

protected:
   virtual void getSimilarOpCodes(OUT ::std::vector< BTSApp2BtsMessageMasterCompareItem >& itemList, IN const App2Bts_BaseMessage* ptrMessage);

   virtual void getMatchingOpCodes(OUT ::std::vector< BTSApp2BtsMessageMasterCompareItem >& itemList, OUT ::std::vector< BTSApp2BtsMessageMasterCompareItem >& highPrioItemList, IN const App2Bts_BaseMessage* ptrMessage);

   virtual bool skipSimilarOpCodeCheck(IN const App2Bts_BaseMessage* ptrMessage);

   virtual void checkWaitingQueueExtended(IN const BTSApp2BtsMessageCompareItem& compareItem);

   virtual void handleDoubledApp2BtsMessages(IN const ::std::vector< App2Bts_BaseMessage* >& msgList);

   void createControlHandler(IN const BTSFunctionBlock component, IN const BTSInterfaceType stackInterface, IN const BTSFunctionBlock subComponent, IN const BTSUserMode userMode, IN const BTSLocalWblConfiguration& configuration);
};

} //wbl
} //btstackif

#endif //_WBL_CONTROL_MAIN_H_
