/**
 * @file WblStackTypes.h
 *
 * @par SW-Component
 * Types
 *
 * @brief Basic types for WBL access.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Definitions of all internal types for WBL access.
 */

#ifndef _WBL_STACK_TYPES_H_
#define _WBL_STACK_TYPES_H_

#include "BtStackInternalTypes.h"
#include "WblStackOpcodes.h"

namespace btstackif {
namespace wbl {

/**
 * Forward declaration of class BTSWblWiFiSetupStatusWbl.
 */
class BTSWblWiFiSetupStatusWbl;

/**
 * Type definition for status list of WBL WiFi setups.
 */
typedef ::std::vector< BTSWblWiFiSetupStatusWbl > BTSWblWiFiSetupStatusWblList;

/**
 * Type definition for interface/component/service.
 */
enum BTSWblDbusServiceInterface
{
   BTS_WBL_DBUS_SERVICE_LAST_INTENDED_MODE = 0, /**< last intended mode */
   BTS_WBL_DBUS_SERVICE_CONFLICT_MANAGEMENT, /**< conflict management */
   BTS_WBL_DBUS_SERVICE_WIFI_SETUP, /**< wifi setup */
   BTS_WBL_DBUS_SERVICE_OBJECT_MANAGER_SYSTEM, /**< object manager system bus */
   // -------------------------------------------------------------------------
   BTS_WBL_DBUS_SERVICE_LAST /**< end marker, must be the last one */
};

/**
 * Type definition for WBL WiFi setup status.
 */
class BTSWblWiFiSetupStatusWbl : public BTSWblWiFiSetupStatus
{
public:
   BTSWblWiFiSetupStatusWbl();
   BTSWblWiFiSetupStatusWbl(IN const BTSWblWiFiSetupStatusWbl& ref);
   BTSWblWiFiSetupStatusWbl& operator=(IN const BTSWblWiFiSetupStatusWbl& ref);
   bool operator==(IN const BTSWblWiFiSetupStatusWbl& ref) const;
   bool operator!=(IN const BTSWblWiFiSetupStatusWbl& ref) const;
   virtual ~BTSWblWiFiSetupStatusWbl();
   // member with public access
   BTSObjectPath objPath; /**< object path */
};

} //wbl
} //btstackif

#endif //_WBL_STACK_TYPES_H_
