/**
 * @file WblStackOpcodes.h
 *
 * @par SW-Component
 * Types
 *
 * @brief Internal opcodes.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Definitions of internal opcodes.
 */

#ifndef _WBL_STACK_OPCODES_H_
#define _WBL_STACK_OPCODES_H_

#include "BtStackIfTypes.h"

namespace btstackif {
namespace wbl {

/**
 * Type definition for opcodes of messages from BtStackIf to IPC.
 */
enum BTSWblBts2IpcOpcode
{
   Bts2IpcOC_None = 0, /**< none */

   // WBL block
   Bts2IpcOC_WblBlockStart = (BTS_FB_WBL << 12),
   // -------------------------------------------------------------------------
   Bts2IpcOC_GetManagedObjectsWbl,
   Bts2IpcOC_GetIntrospectionWbl,
   Bts2IpcOC_GetLastIntendedMode,
   Bts2IpcOC_GetSupportedFrequencies,
   Bts2IpcOC_GetWifiMode,
   Bts2IpcOC_GetWifiPowerState,
   Bts2IpcOC_GetWifiFrequency,
   Bts2IpcOC_GetAccessPointConfigType,
   Bts2IpcOC_GetWifiConnectionStatus,
   // -------------------------------------------------------------------------
   Bts2IpcOC_WblBlockEnd,

   // -------------------------------------------------------------------------
   Bts2IpcOC_Last /**< end marker, must be the last one */
};

/**
 * Type definition for opcodes of messages from IPC to BtStackIf.
 */
enum BTSWblIpc2BtsOpcode
{
   Ipc2BtsOC_None = 0, /**< none */

   // WBL block
   Ipc2BtsOC_WblBlockStart = (1 << 11) | (BTS_FB_WBL << 12),
   // -------------------------------------------------------------------------
   Ipc2BtsOC_ServiceAvailabilityWbl,
   Ipc2BtsOC_GetManagedObjectsWbl,
   Ipc2BtsOC_AddWifiSetupObjectPath,
   Ipc2BtsOC_DelWifiSetupObjectPath,
   Ipc2BtsOC_LastIntendedModeUpdate,
   Ipc2BtsOC_SupportedFrequenciesUpdate,
   Ipc2BtsOC_WifiModeUpdate,
   Ipc2BtsOC_WifiPowerStateUpdate,
   Ipc2BtsOC_WifiFrequencyUpdate,
   Ipc2BtsOC_AccessPointConfigTypeUpdate,
   Ipc2BtsOC_WifiConnectionStatusUpdate,
   // -------------------------------------------------------------------------
   Ipc2BtsOC_WblBlockEnd,

   // -------------------------------------------------------------------------
   Ipc2BtsOC_Last /**< end marker, must be the last one */
};

} //wbl
} //btstackif

#endif //_WBL_STACK_OPCODES_H_
