/**
 * @file TrcBts2Ipc_WBL.cpp
 *
 * @par SW-Component
 * Trace
 *
 * @brief Traces for Bts2Ipc messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of traces for Bts2Ipc messages.
 */

#include "Bts2Ipc_MessageWrapper_WBL.h"
#include "TraceClasses.h"
#include "FwTrace.h"
#include "BtsUtils.h"
#include "WblStackTypes.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BTS_BTS2IPC
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/TrcBts2Ipc_WBL.cpp.trc.h"
#else
#include "BtStackIfTypesTrace.h"
#include "BtStackInternalTypesTrace.h"
#include "WblStackTypesTrace.h"
#include "WblStackOpcodesTrace.h"
#endif
#endif

namespace btstackif {
namespace wbl {

void Bts2Ipc_GetManagedObjectsWbl::doOutputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   ETG_TRACE_USR1((" Bts2Ipc: 0x%08X (%d): TO=%u busType=%d busName=%20s objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblBts2IpcOpcode, opcode),
            getMethodReturnTimeOut(),
            _busType,
            _busName.c_str() /*DONE: format*/,
            _objPath.c_str() /*DONE: format*/));

#else

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   BTS_TRACE_USR1((" Bts2Ipc: 0x%08X (%s): TO=%u busType=%d busName=%20s objPath=%s",
            getMessageTraceId(),
            getWblBts2IpcOpcode2String(opcode),
            getMethodReturnTimeOut(),
            _busType,
            _busName.c_str() /*DONE: format*/,
            _objPath.c_str() /*DONE: format*/));

#endif
}

void Bts2Ipc_GetIntrospectionWbl::doOutputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   ETG_TRACE_USR1((" Bts2Ipc: 0x%08X (%d): TO=%u busType=%d busName=%20s objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblBts2IpcOpcode, opcode),
            getMethodReturnTimeOut(),
            _busType,
            _busName.c_str() /*DONE: format*/,
            _objPath.c_str() /*DONE: format*/));

#else

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   BTS_TRACE_USR1((" Bts2Ipc: 0x%08X (%s): TO=%u busType=%d busName=%20s objPath=%s",
            getMessageTraceId(),
            getWblBts2IpcOpcode2String(opcode),
            getMethodReturnTimeOut(),
            _busType,
            _busName.c_str() /*DONE: format*/,
            _objPath.c_str() /*DONE: format*/));

#endif
}

void Bts2Ipc_GetLastIntendedMode::doOutputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   ETG_TRACE_USR1((" Bts2Ipc: 0x%08X (%d): TO=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblBts2IpcOpcode, opcode),
            getMethodReturnTimeOut()));

#else

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   BTS_TRACE_USR1((" Bts2Ipc: 0x%08X (%s): TO=%u",
            getMessageTraceId(),
            getWblBts2IpcOpcode2String(opcode),
            getMethodReturnTimeOut()));

#endif
}

void Bts2Ipc_GetSupportedFrequencies::doOutputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   ETG_TRACE_USR1((" Bts2Ipc: 0x%08X (%d): TO=%u id=%u objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblBts2IpcOpcode, opcode),
            getMethodReturnTimeOut(),
            _id,
            _objPath.c_str()));

#else

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   BTS_TRACE_USR1((" Bts2Ipc: 0x%08X (%s): TO=%u id=%u objPath=%s",
            getMessageTraceId(),
            getWblBts2IpcOpcode2String(opcode),
            getMethodReturnTimeOut(),
            _id,
            _objPath.c_str()));

#endif
}

void Bts2Ipc_GetWifiMode::doOutputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   ETG_TRACE_USR1((" Bts2Ipc: 0x%08X (%d): TO=%u id=%u objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblBts2IpcOpcode, opcode),
            getMethodReturnTimeOut(),
            _id,
            _objPath.c_str()));

#else

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   BTS_TRACE_USR1((" Bts2Ipc: 0x%08X (%s): TO=%u id=%u objPath=%s",
            getMessageTraceId(),
            getWblBts2IpcOpcode2String(opcode),
            getMethodReturnTimeOut(),
            _id,
            _objPath.c_str()));

#endif
}

void Bts2Ipc_GetWifiPowerState::doOutputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   ETG_TRACE_USR1((" Bts2Ipc: 0x%08X (%d): TO=%u id=%u objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblBts2IpcOpcode, opcode),
            getMethodReturnTimeOut(),
            _id,
            _objPath.c_str()));

#else

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   BTS_TRACE_USR1((" Bts2Ipc: 0x%08X (%s): TO=%u id=%u objPath=%s",
            getMessageTraceId(),
            getWblBts2IpcOpcode2String(opcode),
            getMethodReturnTimeOut(),
            _id,
            _objPath.c_str()));

#endif
}

void Bts2Ipc_GetWifiFrequency::doOutputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   ETG_TRACE_USR1((" Bts2Ipc: 0x%08X (%d): TO=%u id=%u objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblBts2IpcOpcode, opcode),
            getMethodReturnTimeOut(),
            _id,
            _objPath.c_str()));

#else

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   BTS_TRACE_USR1((" Bts2Ipc: 0x%08X (%s): TO=%u id=%u objPath=%s",
            getMessageTraceId(),
            getWblBts2IpcOpcode2String(opcode),
            getMethodReturnTimeOut(),
            _id,
            _objPath.c_str()));

#endif
}

void Bts2Ipc_GetAccessPointConfigType::doOutputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   ETG_TRACE_USR1((" Bts2Ipc: 0x%08X (%d): TO=%u id=%u objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblBts2IpcOpcode, opcode),
            getMethodReturnTimeOut(),
            _id,
            _objPath.c_str()));

#else

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   BTS_TRACE_USR1((" Bts2Ipc: 0x%08X (%s): TO=%u id=%u objPath=%s",
            getMessageTraceId(),
            getWblBts2IpcOpcode2String(opcode),
            getMethodReturnTimeOut(),
            _id,
            _objPath.c_str()));

#endif
}

void Bts2Ipc_GetWifiConnectionStatus::doOutputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   ETG_TRACE_USR1((" Bts2Ipc: 0x%08X (%d): TO=%u id=%u objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblBts2IpcOpcode, opcode),
            getMethodReturnTimeOut(),
            _id,
            _objPath.c_str()));

#else

   BTSWblBts2IpcOpcode opcode = (BTSWblBts2IpcOpcode)_opCode;
   BTS_TRACE_USR1((" Bts2Ipc: 0x%08X (%s): TO=%u id=%u objPath=%s",
            getMessageTraceId(),
            getWblBts2IpcOpcode2String(opcode),
            getMethodReturnTimeOut(),
            _id,
            _objPath.c_str()));

#endif
}

} //wbl
} //btstackif
