/**
 * @file Bts2Ipc_Wbl_WBL.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to IPC messages for function block BTS_FB_WBL.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_WBL.
 */

#include "Bts2Ipc_Wbl_WBL.h"
#include "WblStackTypes.h"

namespace btstackif {
namespace wbl {

Bts2Ipc_GetManagedObjectsWbl::Bts2Ipc_GetManagedObjectsWbl()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Bts2IpcOC_GetManagedObjectsWbl))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_WBL);
}

Bts2Ipc_GetManagedObjectsWbl::Bts2Ipc_GetManagedObjectsWbl(IN const Bts2Ipc_GetManagedObjectsWbl& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Bts2Ipc_GetManagedObjectsWbl& Bts2Ipc_GetManagedObjectsWbl::operator=(IN const Bts2Ipc_GetManagedObjectsWbl& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetManagedObjectsWbl::~Bts2Ipc_GetManagedObjectsWbl()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetManagedObjectsWbl::clone(void) const
{
   return new Bts2Ipc_GetManagedObjectsWbl(*this);
}

Bts2Ipc_GetIntrospectionWbl::Bts2Ipc_GetIntrospectionWbl()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Bts2IpcOC_GetIntrospectionWbl))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_WBL);
}

Bts2Ipc_GetIntrospectionWbl::Bts2Ipc_GetIntrospectionWbl(IN const Bts2Ipc_GetIntrospectionWbl& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Bts2Ipc_GetIntrospectionWbl& Bts2Ipc_GetIntrospectionWbl::operator=(IN const Bts2Ipc_GetIntrospectionWbl& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetIntrospectionWbl::~Bts2Ipc_GetIntrospectionWbl()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetIntrospectionWbl::clone(void) const
{
   return new Bts2Ipc_GetIntrospectionWbl(*this);
}

Bts2Ipc_GetLastIntendedMode::Bts2Ipc_GetLastIntendedMode()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Bts2IpcOC_GetLastIntendedMode))
{
   setBtsSourceFunctionBlock(BTS_FB_WBL);
}

Bts2Ipc_GetLastIntendedMode::Bts2Ipc_GetLastIntendedMode(IN const Bts2Ipc_GetLastIntendedMode& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetLastIntendedMode& Bts2Ipc_GetLastIntendedMode::operator=(IN const Bts2Ipc_GetLastIntendedMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetLastIntendedMode::~Bts2Ipc_GetLastIntendedMode()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetLastIntendedMode::clone(void) const
{
   return new Bts2Ipc_GetLastIntendedMode(*this);
}

Bts2Ipc_GetSupportedFrequencies::Bts2Ipc_GetSupportedFrequencies()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Bts2IpcOC_GetSupportedFrequencies))
{
   _id = 0;
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_WBL);
}

Bts2Ipc_GetSupportedFrequencies::Bts2Ipc_GetSupportedFrequencies(IN const Bts2Ipc_GetSupportedFrequencies& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _id = ref._id;
   _objPath = ref._objPath;
}

Bts2Ipc_GetSupportedFrequencies& Bts2Ipc_GetSupportedFrequencies::operator=(IN const Bts2Ipc_GetSupportedFrequencies& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _id = ref._id;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetSupportedFrequencies::~Bts2Ipc_GetSupportedFrequencies()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetSupportedFrequencies::clone(void) const
{
   return new Bts2Ipc_GetSupportedFrequencies(*this);
}

Bts2Ipc_GetWifiMode::Bts2Ipc_GetWifiMode()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Bts2IpcOC_GetWifiMode))
{
   _id = 0;
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_WBL);
}

Bts2Ipc_GetWifiMode::Bts2Ipc_GetWifiMode(IN const Bts2Ipc_GetWifiMode& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _id = ref._id;
   _objPath = ref._objPath;
}

Bts2Ipc_GetWifiMode& Bts2Ipc_GetWifiMode::operator=(IN const Bts2Ipc_GetWifiMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _id = ref._id;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetWifiMode::~Bts2Ipc_GetWifiMode()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetWifiMode::clone(void) const
{
   return new Bts2Ipc_GetWifiMode(*this);
}

Bts2Ipc_GetWifiPowerState::Bts2Ipc_GetWifiPowerState()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Bts2IpcOC_GetWifiPowerState))
{
   _id = 0;
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_WBL);
}

Bts2Ipc_GetWifiPowerState::Bts2Ipc_GetWifiPowerState(IN const Bts2Ipc_GetWifiPowerState& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _id = ref._id;
   _objPath = ref._objPath;
}

Bts2Ipc_GetWifiPowerState& Bts2Ipc_GetWifiPowerState::operator=(IN const Bts2Ipc_GetWifiPowerState& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _id = ref._id;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetWifiPowerState::~Bts2Ipc_GetWifiPowerState()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetWifiPowerState::clone(void) const
{
   return new Bts2Ipc_GetWifiPowerState(*this);
}

Bts2Ipc_GetWifiFrequency::Bts2Ipc_GetWifiFrequency()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Bts2IpcOC_GetWifiFrequency))
{
   _id = 0;
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_WBL);
}

Bts2Ipc_GetWifiFrequency::Bts2Ipc_GetWifiFrequency(IN const Bts2Ipc_GetWifiFrequency& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _id = ref._id;
   _objPath = ref._objPath;
}

Bts2Ipc_GetWifiFrequency& Bts2Ipc_GetWifiFrequency::operator=(IN const Bts2Ipc_GetWifiFrequency& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _id = ref._id;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetWifiFrequency::~Bts2Ipc_GetWifiFrequency()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetWifiFrequency::clone(void) const
{
   return new Bts2Ipc_GetWifiFrequency(*this);
}

Bts2Ipc_GetAccessPointConfigType::Bts2Ipc_GetAccessPointConfigType()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Bts2IpcOC_GetAccessPointConfigType))
{
   _id = 0;
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_WBL);
}

Bts2Ipc_GetAccessPointConfigType::Bts2Ipc_GetAccessPointConfigType(IN const Bts2Ipc_GetAccessPointConfigType& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _id = ref._id;
   _objPath = ref._objPath;
}

Bts2Ipc_GetAccessPointConfigType& Bts2Ipc_GetAccessPointConfigType::operator=(IN const Bts2Ipc_GetAccessPointConfigType& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _id = ref._id;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetAccessPointConfigType::~Bts2Ipc_GetAccessPointConfigType()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAccessPointConfigType::clone(void) const
{
   return new Bts2Ipc_GetAccessPointConfigType(*this);
}

Bts2Ipc_GetWifiConnectionStatus::Bts2Ipc_GetWifiConnectionStatus()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_WBL), (BTSCommonEnumClass)(Bts2IpcOC_GetWifiConnectionStatus))
{
   _id = 0;
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_WBL);
}

Bts2Ipc_GetWifiConnectionStatus::Bts2Ipc_GetWifiConnectionStatus(IN const Bts2Ipc_GetWifiConnectionStatus& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _id = ref._id;
   _objPath = ref._objPath;
}

Bts2Ipc_GetWifiConnectionStatus& Bts2Ipc_GetWifiConnectionStatus::operator=(IN const Bts2Ipc_GetWifiConnectionStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _id = ref._id;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetWifiConnectionStatus::~Bts2Ipc_GetWifiConnectionStatus()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetWifiConnectionStatus::clone(void) const
{
   return new Bts2Ipc_GetWifiConnectionStatus(*this);
}

} //wbl
} //btstackif
