/**
 * @file Bts2Ipc_MessageWrapper_WBL.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief Wrapper for BtStackIf to IPC messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wrapper for BtStackIf to IPC messages.
 * The only reason for this file is to solve following lint warnings:
 * Warning 429: prio2: Custodial pointer 'ptrMessage' ...
 */

#ifndef _BTS_2_IPC_MESSAGE_WRAPPER_WBL_H_
#define _BTS_2_IPC_MESSAGE_WRAPPER_WBL_H_

#include "Bts2Ipc_Wbl_WBL.h"

namespace btstackif {
namespace wbl {

inline Bts2Ipc_GetManagedObjectsWbl* ptrNew_Bts2Ipc_GetManagedObjectsWbl(void) { return new Bts2Ipc_GetManagedObjectsWbl(); }
inline Bts2Ipc_GetIntrospectionWbl* ptrNew_Bts2Ipc_GetIntrospectionWbl(void) { return new Bts2Ipc_GetIntrospectionWbl(); }
inline Bts2Ipc_GetLastIntendedMode* ptrNew_Bts2Ipc_GetLastIntendedMode(void) { return new Bts2Ipc_GetLastIntendedMode(); }
inline Bts2Ipc_GetSupportedFrequencies* ptrNew_Bts2Ipc_GetSupportedFrequencies(void) { return new Bts2Ipc_GetSupportedFrequencies(); }
inline Bts2Ipc_GetWifiMode* ptrNew_Bts2Ipc_GetWifiMode(void) { return new Bts2Ipc_GetWifiMode(); }
inline Bts2Ipc_GetWifiPowerState* ptrNew_Bts2Ipc_GetWifiPowerState(void) { return new Bts2Ipc_GetWifiPowerState(); }
inline Bts2Ipc_GetWifiFrequency* ptrNew_Bts2Ipc_GetWifiFrequency(void) { return new Bts2Ipc_GetWifiFrequency(); }
inline Bts2Ipc_GetAccessPointConfigType* ptrNew_Bts2Ipc_GetAccessPointConfigType(void) { return new Bts2Ipc_GetAccessPointConfigType(); }
inline Bts2Ipc_GetWifiConnectionStatus* ptrNew_Bts2Ipc_GetWifiConnectionStatus(void) { return new Bts2Ipc_GetWifiConnectionStatus(); }

} //wbl
} //btstackif

#endif //_BTS_2_IPC_MESSAGE_WRAPPER_WBL_H_
