/**
 * @file PanConnectDisconnectDataGenivi.cpp
 *
 * @par SW-Component
 * State machine for PAN connect/disconnect
 *
 * @brief Implementation of Genivi PAN connect/disconnect state machine data.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of Genivi PAN connect/disconnect state machine data.
 */

#include "PanConnectDisconnectDataGenivi.h"

namespace btstackif {
namespace genivi {

PanConnectDisconnectDataGenivi::PanConnectDisconnectDataGenivi() :
serviceConnManManagerTimer(),
serviceConnManServiceTimer()
{
}

PanConnectDisconnectDataGenivi::~PanConnectDisconnectDataGenivi()
{
}

PanConnectDisconnectDataGenivi::PanConnectDisconnectDataGenivi(const PanConnectDisconnectDataGenivi& ref) :
serviceConnManManagerTimer(ref.serviceConnManManagerTimer),
serviceConnManServiceTimer(ref.serviceConnManServiceTimer)
{
}

PanConnectDisconnectDataGenivi& PanConnectDisconnectDataGenivi::operator=(const PanConnectDisconnectDataGenivi& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   serviceConnManManagerTimer = ref.serviceConnManManagerTimer;
   serviceConnManServiceTimer = ref.serviceConnManServiceTimer;

   return *this;
}

bool PanConnectDisconnectDataGenivi::operator==(const PanConnectDisconnectDataGenivi& ref) const
{
   bool result = true;

   result = (true == result) && (serviceConnManManagerTimer == ref.serviceConnManManagerTimer);
   result = (true == result) && (serviceConnManServiceTimer == ref.serviceConnManServiceTimer);

   return result;
}

bool PanConnectDisconnectDataGenivi::operator!=(const PanConnectDisconnectDataGenivi& ref) const
{
   return !(operator==(ref));
}

} //genivi
} //btstackif
