/**
 * @file PairingGeniviData.cpp
 *
 * @par SW-Component
 * State machine for pairing
 *
 * @brief Implementation of pairing data.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of pairing data.
 */

#include "PairingGeniviData.h"

namespace btstackif {

PairingGeniviData::PairingGeniviData() :
device(),
sspMode(BTS_SSP_LAST),
numValue()
{
}

PairingGeniviData::~PairingGeniviData()
{
}

PairingGeniviData::PairingGeniviData(const PairingGeniviData& ref)
{
   device = ref.device;
   sspMode = ref.sspMode;
   numValue = ref.numValue;
}

PairingGeniviData& PairingGeniviData::operator=(const PairingGeniviData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   device = ref.device;
   sspMode = ref.sspMode;
   numValue = ref.numValue;

   return *this;
}

bool PairingGeniviData::operator==(const PairingGeniviData& ref) const
{
   bool result = true;

   result = (true == result) && (device == ref.device);
   result = (true == result) && (sspMode == ref.sspMode);
   result = (true == result) && (numValue == ref.numValue);

   return result;
}

bool PairingGeniviData::operator!=(const PairingGeniviData& ref) const
{
   return !(operator==(ref));
}

} //btstackif
