/**
 * @file ObexConnectDisconnectDataGenivi.cpp
 *
 * @par SW-Component
 * State machine for OBEX connect/disconnect
 *
 * @brief Implementation of Genivi OBEX connect/disconnect state machine data.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of Genivi OBEX connect/disconnect state machine data.
 */

#include "ObexConnectDisconnectDataGenivi.h"

namespace btstackif {
namespace genivi {

ObexConnectDisconnectDataGenivi::ObexConnectDisconnectDataGenivi() :
statusUpdateTimer()
{
}

ObexConnectDisconnectDataGenivi::~ObexConnectDisconnectDataGenivi()
{
}

ObexConnectDisconnectDataGenivi::ObexConnectDisconnectDataGenivi(const ObexConnectDisconnectDataGenivi& ref) :
statusUpdateTimer(ref.statusUpdateTimer)
{
}

ObexConnectDisconnectDataGenivi& ObexConnectDisconnectDataGenivi::operator=(const ObexConnectDisconnectDataGenivi& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   statusUpdateTimer = ref.statusUpdateTimer;

   return *this;
}

bool ObexConnectDisconnectDataGenivi::operator==(const ObexConnectDisconnectDataGenivi& ref) const
{
   bool result = true;

   result = (true == result) && (statusUpdateTimer == ref.statusUpdateTimer);

   return result;
}

bool ObexConnectDisconnectDataGenivi::operator!=(const ObexConnectDisconnectDataGenivi& ref) const
{
   return !(operator==(ref));
}

} //genivi
} //btstackif
