/**
 * @file RssiGenivi.h
 *
 * @par SW-Component
 * State machine for RSSI
 *
 * @brief Implementation of Genivi RSSI state machine.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Genivi RSSI state machine.
 */

#ifndef _RSSI_GENIVI_H_
#define _RSSI_GENIVI_H_

#include "IRssiRequest.h"
#include "IRssiGenivi.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

// class forward declarations
class IObjectPathManagerGenivi;

/**
 * RSSI class.
 */
class RssiGenivi : public IRssiRequest, public IRssiGenivi
{
public:
   /**
    * Default constructor.
    */
   RssiGenivi();

   /**
    * Destructor.
    */
   virtual ~RssiGenivi();

   virtual void reset(void);

   virtual void setCallback(IN IRssiCallback* callback);

   virtual void getLinkQuality(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSBDAddress& address);

   virtual void setObjectPathManagerIf(IN IObjectPathManagerGenivi* objectPathManager);

   virtual void handleDeviceRssiUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& device, IN const BTSRssi rssi, IN const BTSIpcCommonErrorCode errorCode, IN const bool response);

private:
   IRssiCallback* _callback; /**< callback interface */
   IObjectPathManagerGenivi* _objectPathManagerIf; /**< object path manager interface */

   void createGetDeviceRssiMsg(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, IN const BTSBDAddress& address, IN const BTSObjectPath& device) const;
};

} //genivi
} //btstackif

#endif //_RSSI_GENIVI_H_
