/**
 * @file PanConnectDisconnectDataGenivi.h
 *
 * @par SW-Component
 * State machine for PAN connect/disconnect
 *
 * @brief Implementation of Genivi PAN connect/disconnect state machine data.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Genivi PAN connect/disconnect state machine data.
 */

#ifndef _PAN_CONNECT_DISCONNECT_DATA_GENIVI_H_
#define _PAN_CONNECT_DISCONNECT_DATA_GENIVI_H_

#include "BtStackInternalTypes.h"
#include "ExtendedTimerEntry.h"

namespace btstackif {
namespace genivi {

/**
 * PAN connect/disconnect state machine data class.
 */
class PanConnectDisconnectDataGenivi
{
public:
   /**
    * Default constructor.
    */
   PanConnectDisconnectDataGenivi();

   /**
    * Destructor.
    */
   virtual ~PanConnectDisconnectDataGenivi();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   PanConnectDisconnectDataGenivi(const PanConnectDisconnectDataGenivi& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   PanConnectDisconnectDataGenivi& operator=(const PanConnectDisconnectDataGenivi& ref);

   /**
    * Equality operator.
    *
    * @param[in] ref: reference of message to be compared
    */
   bool operator==(const PanConnectDisconnectDataGenivi& ref) const;

   /**
    * Inequality operator.
    *
    * @param[in] ref: reference of message to be compared
    */
   bool operator!=(const PanConnectDisconnectDataGenivi& ref) const;

   // member with public access
   ExtendedTimerEntry serviceConnManManagerTimer; /**< timer for availability of ConnMan manager service */
   ExtendedTimerEntry serviceConnManServiceTimer; /**< timer for availability of ConnMan service service */
};

} //genivi
} //btstackif

#endif //_PAN_CONNECT_DISCONNECT_DATA_GENIVI_H_
