/**
 * @file PairingGeniviData.h
 *
 * @par SW-Component
 * State machine for pairing
 *
 * @brief Implementation of pairing data.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of pairing data.
 */

#ifndef _PAIRING_GENIVI_DATA_H_
#define _PAIRING_GENIVI_DATA_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

/**
 * Pairing data class.
 */
class PairingGeniviData
{
public:
   /**
    * Default constructor.
    */
   PairingGeniviData();

   /**
    * Destructor.
    */
   virtual ~PairingGeniviData();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   PairingGeniviData(const PairingGeniviData& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   PairingGeniviData& operator=(const PairingGeniviData& ref);

   /**
    * Equality operator.
    *
    * @param[in] ref: reference of message to be compared
    */
   bool operator==(const PairingGeniviData& ref) const;

   /**
    * Inequality operator.
    *
    * @param[in] ref: reference of message to be compared
    */
   bool operator!=(const PairingGeniviData& ref) const;

   // member with public access
   BTSObjectPath device; /**< device object path */
   BTSSspMode sspMode; /**< pairing mode */
   BTSNumericValue numValue; /**< numeric value */
};

} //btstackif

#endif //_PAIRING_GENIVI_DATA_H_
