/**
 * @file LocalBluetoothNameGenivi.h
 *
 * @par SW-Component
 * State machine for setting local Bluetooth name
 *
 * @brief Implementation of Genivi setting local Bluetooth name state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Genivi setting local Bluetooth name state machine.
 */

#ifndef _LOCAL_BLUETOOTH_NAME_GENIVI_H_
#define _LOCAL_BLUETOOTH_NAME_GENIVI_H_

#include "ILocalBluetoothNameRequest.h"
#include "ILocalBluetoothNameGenivi.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

/**
 * Setting local Bluetooth name class.
 */
class LocalBluetoothNameGenivi : public ILocalBluetoothNameRequest, public ILocalBluetoothNameGenivi
{
public:
   /**
    * Default constructor.
    */
   LocalBluetoothNameGenivi();

   /**
    * Destructor.
    */
   virtual ~LocalBluetoothNameGenivi();

   virtual void reset(void);

   virtual void setCallback(IN ILocalBluetoothNameCallback* callback);

   virtual void setControlIf(IN IBasicControl* control);

   virtual void setLocalName(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSDeviceName& name);

   virtual void sendVirtualLocalNameUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSDeviceName& name, IN const BTSIpcCommonErrorCode errorCode);

   virtual ILocalBluetoothNameRequest* getRequestIf(void);

   virtual void handleLocalNameUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSDeviceName& name, IN const BTSIpcCommonErrorCode errorCode, IN const bool response);

   virtual void handleAdapterProperties(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSDbusPropertyList& properties, IN const BTSIpcCommonErrorCode errorCode);

private:
   ILocalBluetoothNameCallback* _callback; /**< callback interface */
   IBasicControl* _controlIf; /**< basic control interface */
   bool _adapterDataReceived; /**< flag for data received */

   void setStackLocalBtName(IN const BTSDeviceName& name);
};

} //genivi
} //btstackif

#endif //_LOCAL_BLUETOOTH_NAME_GENIVI_H_
