/**
 * @file ILocalBluetoothNameGenivi.h
 *
 * @par SW-Component
 * State machine for setting local Bluetooth name
 *
 * @brief Interface definition for Genivi setting local Bluetooth name state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the Genivi interface for setting local Bluetooth name state machine.
 */

#ifndef _I_LOCAL_BLUETOOTH_NAME_GENIVI_H_
#define _I_LOCAL_BLUETOOTH_NAME_GENIVI_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class ILocalBluetoothNameRequest;
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

namespace genivi {

/**
 * Interface definition.
 */
class ILocalBluetoothNameGenivi
{
public:
   /**
    * Destructor.
    */
   virtual ~ILocalBluetoothNameGenivi() {}

   /**
    * Get request interface.
    *
    * @return = request interface
    */
   virtual ILocalBluetoothNameRequest* getRequestIf(void) = 0;

   /**
    * Handle local name update message.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] name: local name
    * @param[in] errorCode: error code
    * @param[in] response: response flag (update or return)
    */
   virtual void handleLocalNameUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSDeviceName& name, IN const BTSIpcCommonErrorCode errorCode, IN const bool response) = 0;

   /**
    * Handle received adapter properties.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] properties: properties
    * @param[in] errorCode: error code
    */
   virtual void handleAdapterProperties(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSDbusPropertyList& properties, IN const BTSIpcCommonErrorCode errorCode) = 0;
};

} //genivi
} //btstackif

#endif //_I_LOCAL_BLUETOOTH_NAME_GENIVI_H_
