/**
 * @file IBasicConfigurationGenivi.h
 *
 * @par SW-Component
 * State machine for basic configuration
 *
 * @brief Interface definition for Genivi basic configuration state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the Genivi basic configuration state machine.
 */

#ifndef _I_BASIC_CONFIGURATION_GENIVI_H_
#define _I_BASIC_CONFIGURATION_GENIVI_H_

#include "EvolutionGeniviStackTypes.h"

namespace btstackif {

// class forward declarations
class IBasicConfigurationRequest;
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

namespace genivi {

/**
 * Interface definition.
 */
class IBasicConfigurationGenivi
{
public:
   /**
    * Destructor.
    */
   virtual ~IBasicConfigurationGenivi() {}

   /**
    * Get request interface.
    *
    * @return = request interface
    */
   virtual IBasicConfigurationRequest* getRequestIf(void) = 0;

   /**
    * Handle adapter UUIDs update message.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] uuidList: UUID list
    * @param[in] errorCode: error code
    * @param[in] response: response flag (update or return)
    */
   virtual void handleAdapterUuidsUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSUuidList& uuidList, IN const BTSIpcCommonErrorCode errorCode, IN const bool response) = 0;
};

} //genivi
} //btstackif

#endif //_I_BASIC_CONFIGURATION_GENIVI_H_
