/**
 * @file HfpAvpConnectDisconnectDataGenivi.h
 *
 * @par SW-Component
 * State machine for HFP/AVP connect/disconnect
 *
 * @brief Implementation of Genivi HFP/AVP connect/disconnect state machine data.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Genivi HFP/AVP connect/disconnect state machine data.
 */

#ifndef _HFP_AVP_CONNECT_DISCONNECT_DATA_GENIVI_H_
#define _HFP_AVP_CONNECT_DISCONNECT_DATA_GENIVI_H_

#include "BtStackInternalTypes.h"
#include "ExtendedTimerEntry.h"

namespace btstackif {
namespace genivi {

/**
 * HFP/AVP connect/disconnect state machine data class.
 */
class HfpAvpConnectDisconnectDataGenivi
{
public:
   /**
    * Default constructor.
    */
   HfpAvpConnectDisconnectDataGenivi();

   /**
    * Destructor.
    */
   virtual ~HfpAvpConnectDisconnectDataGenivi();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   HfpAvpConnectDisconnectDataGenivi(const HfpAvpConnectDisconnectDataGenivi& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   HfpAvpConnectDisconnectDataGenivi& operator=(const HfpAvpConnectDisconnectDataGenivi& ref);

   /**
    * Equality operator.
    *
    * @param[in] ref: reference of message to be compared
    */
   bool operator==(const HfpAvpConnectDisconnectDataGenivi& ref) const;

   /**
    * Inequality operator.
    *
    * @param[in] ref: reference of message to be compared
    */
   bool operator!=(const HfpAvpConnectDisconnectDataGenivi& ref) const;

   // member with public access
   ExtendedTimerEntry serviceSppServiceTimer; /**< timer for availability of SPP service service */
   bool serialIfAdded; /**< flag for added serial interface */
   bool serialIfAvailable; /**< flag for available serial interface */
};

} //genivi
} //btstackif

#endif //_HFP_AVP_CONNECT_DISCONNECT_DATA_GENIVI_H_
