/**
 * @file BasicConfigurationGenivi.h
 *
 * @par SW-Component
 * State machine for basic configuration
 *
 * @brief Implementation of Genivi basic configuration state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Genivi basic configuration state machine.
 */

#ifndef _BASIC_CONFIGURATION_GENIVI_H_
#define _BASIC_CONFIGURATION_GENIVI_H_

#include "IBasicConfigurationRequest.h"
#include "IBasicConfigurationGenivi.h"

namespace btstackif {

// class forward declarations
class Ipc2Bts_BaseMessage;

namespace genivi {

/**
 * Genivi basic configuration class.
 */
class BasicConfigurationGenivi : public IBasicConfigurationRequest, public IBasicConfigurationGenivi
{
public:
   /**
    * Default constructor.
    */
   BasicConfigurationGenivi();

   /**
    * Destructor.
    */
   virtual ~BasicConfigurationGenivi();

   virtual void reset(void);

   virtual void setCallback(IN IBasicConfigurationCallback* callback);

   virtual void setControlIf(IN IBasicControl* control);

   virtual void getConfigurationParameter(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter);

   virtual void setConfigurationParameter(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter, IN const uint64_t data);

   virtual void setConfigurationParameter(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter, IN const ::std::string& data);

   virtual void sendVirtualConfigurationParameterUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter, IN const uint64_t data, IN const BTSIpcCommonErrorCode errorCode);

   virtual void sendVirtualConfigurationParameterUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter, IN const ::std::string& data, IN const BTSIpcCommonErrorCode errorCode);

   virtual IBasicConfigurationRequest* getRequestIf(void);

   virtual void handleAdapterUuidsUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSUuidList& uuidList, IN const BTSIpcCommonErrorCode errorCode, IN const bool response);

private:
   IBasicConfigurationCallback* _callback; /**< callback interface */
   IBasicControl* _controlIf; /**< basic control interface */

   void createGetAdapterUuidsMsg(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList) const;

   void createSetAdapterUuidsMsg(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, IN const uint64_t data) const;

   Ipc2Bts_BaseMessage* createVirtualAdapterUuidsUpdateMsg(IN const uint64_t data, IN const BTSIpcCommonErrorCode errorCode) const;

   void convertServices2Uuids(OUT BTSUuidList& uuids, IN const unsigned short int data) const;

   void convertUuids2Services(OUT unsigned short int& data, IN const BTSUuidList& uuids) const;
};

} //genivi
} //btstackif

#endif //_BASIC_CONFIGURATION_GENIVI_H_
