/**
 * @file TrcIpc2BtsProperty_GEN.cpp
 *
 * @par SW-Component
 * Trace
 *
 * @brief Traces for Ipc2Bts messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of traces for Ipc2Bts messages.
 */

#include "TrcIpc2BtsProperty_GEN.h"
#include "TraceClasses.h"
#include "FwTrace.h"
#include "BtsUtils.h"
#include "EvolutionGeniviStackTypes.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BTS_IPC2BTS
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/TrcIpc2BtsProperty_GEN.cpp.trc.h"
#else
#include "BtStackIfTypesTrace.h"
#include "BtStackInternalTypesTrace.h"
#include "EvolutionGeniviStackTypesTrace.h"
#include "EvolutionGeniviStackOpcodesTrace.h"
#endif
#endif

namespace btstackif {
namespace genivi {

void doPropertyTrace(IN const uint32_t opCodeVal, IN const BTSGenIpc2BtsOpcode opcode, IN const ::ccdbusif::evolution::Interface interface, IN const BTSDbusPropertyList& properties)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   for(size_t i = 0; i < properties.size(); i++)
   {
      switch(interface)
      {
         //#####################################################################
         case ::ccdbusif::evolution::IF_ADAPTER:
            switch(properties[i].propData.getType())
            {
               case ::ccdbusif::VARIANT_INT8:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum),
                           properties[i].propData.getInt8()));
                  break;
               case ::ccdbusif::VARIANT_UINT8:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%u",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum),
                           properties[i].propData.getUInt8()));
                  break;
               case ::ccdbusif::VARIANT_INT16:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum),
                           properties[i].propData.getInt16()));
                  break;
               case ::ccdbusif::VARIANT_UINT16:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%u",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum),
                           properties[i].propData.getUInt16()));
                  break;
               case ::ccdbusif::VARIANT_INT32:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum),
                           properties[i].propData.getInt32()));
                  break;
               case ::ccdbusif::VARIANT_UINT32:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%u",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum),
                           properties[i].propData.getUInt32()));
                  break;
               case ::ccdbusif::VARIANT_INT64:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum),
                           properties[i].propData.getInt64()));
                  break;
               case ::ccdbusif::VARIANT_UINT64:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%u",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum),
                           properties[i].propData.getUInt64()));
                  break;
               case ::ccdbusif::VARIANT_ENUM:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum),
                           properties[i].propData.getEnum()));
                  break;
               case ::ccdbusif::VARIANT_BOOL:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum),
                           properties[i].propData.getBool()));
                  break;
               case ::ccdbusif::VARIANT_STRING:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%s",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum),
                           properties[i].propData.getString().c_str()));
                  break;
               case ::ccdbusif::VARIANT_STRING_ARRAY:
                  for(size_t j = 0; j < properties[i].propData.getStringArray().size(); j++)
                  {
                     ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u][%u]: %d=%s",
                              opCodeVal,
                              ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                              i,
                              j,
                              ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum),
                              properties[i].propData.getStringArray()[j].c_str()));
                  }
                  break;
               case ::ccdbusif::VARIANT_UNKNOWN:
               default:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=<unknown type>",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFAdapterProperty, properties[i].propEnum)));
                  break;
            }
            break;
         //#####################################################################
         case ::ccdbusif::evolution::IF_DEVICE:
            switch(properties[i].propData.getType())
            {
               case ::ccdbusif::VARIANT_INT8:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum),
                           properties[i].propData.getInt8()));
                  break;
               case ::ccdbusif::VARIANT_UINT8:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%u",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum),
                           properties[i].propData.getUInt8()));
                  break;
               case ::ccdbusif::VARIANT_INT16:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum),
                           properties[i].propData.getInt16()));
                  break;
               case ::ccdbusif::VARIANT_UINT16:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%u",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum),
                           properties[i].propData.getUInt16()));
                  break;
               case ::ccdbusif::VARIANT_INT32:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum),
                           properties[i].propData.getInt32()));
                  break;
               case ::ccdbusif::VARIANT_UINT32:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%u",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum),
                           properties[i].propData.getUInt32()));
                  break;
               case ::ccdbusif::VARIANT_INT64:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum),
                           properties[i].propData.getInt64()));
                  break;
               case ::ccdbusif::VARIANT_UINT64:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%u",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum),
                           properties[i].propData.getUInt64()));
                  break;
               case ::ccdbusif::VARIANT_ENUM:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum),
                           properties[i].propData.getEnum()));
                  break;
               case ::ccdbusif::VARIANT_BOOL:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum),
                           properties[i].propData.getBool()));
                  break;
               case ::ccdbusif::VARIANT_STRING:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%s",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum),
                           properties[i].propData.getString().c_str()));
                  break;
               case ::ccdbusif::VARIANT_STRING_ARRAY:
                  for(size_t j = 0; j < properties[i].propData.getStringArray().size(); j++)
                  {
                     ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u][%u]: %d=%s",
                              opCodeVal,
                              ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                              i,
                              j,
                              ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum),
                              properties[i].propData.getStringArray()[j].c_str()));
                  }
                  break;
               case ::ccdbusif::VARIANT_UNKNOWN:
               default:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=<unknown type>",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFDeviceProperty, properties[i].propEnum)));
                  break;
            }
            break;
         //#####################################################################
         case ::ccdbusif::evolution::IF_SERVICE:
            switch(properties[i].propData.getType())
            {
               case ::ccdbusif::VARIANT_INT8:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum),
                           properties[i].propData.getInt8()));
                  break;
               case ::ccdbusif::VARIANT_UINT8:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%u",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum),
                           properties[i].propData.getUInt8()));
                  break;
               case ::ccdbusif::VARIANT_INT16:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum),
                           properties[i].propData.getInt16()));
                  break;
               case ::ccdbusif::VARIANT_UINT16:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%u",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum),
                           properties[i].propData.getUInt16()));
                  break;
               case ::ccdbusif::VARIANT_INT32:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum),
                           properties[i].propData.getInt32()));
                  break;
               case ::ccdbusif::VARIANT_UINT32:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%u",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum),
                           properties[i].propData.getUInt32()));
                  break;
               case ::ccdbusif::VARIANT_INT64:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum),
                           properties[i].propData.getInt64()));
                  break;
               case ::ccdbusif::VARIANT_UINT64:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%u",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum),
                           properties[i].propData.getUInt64()));
                  break;
               case ::ccdbusif::VARIANT_ENUM:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum),
                           properties[i].propData.getEnum()));
                  break;
               case ::ccdbusif::VARIANT_BOOL:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%d",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum),
                           properties[i].propData.getBool()));
                  break;
               case ::ccdbusif::VARIANT_STRING:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=%s",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum),
                           properties[i].propData.getString().c_str()));
                  break;
               case ::ccdbusif::VARIANT_STRING_ARRAY:
                  for(size_t j = 0; j < properties[i].propData.getStringArray().size(); j++)
                  {
                     ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u][%u]: %d=%s",
                              opCodeVal,
                              ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                              i,
                              j,
                              ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum),
                              properties[i].propData.getStringArray()[j].c_str()));
                  }
                  break;
               case ::ccdbusif::VARIANT_UNKNOWN:
               default:
                  ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): property[%u]: %d=<unknown type>",
                           opCodeVal,
                           ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode),
                           i,
                           ETG_ENUM(TRC_CCDBUSIFServiceProperty, properties[i].propEnum)));
                  break;
            }
            break;
         //#####################################################################
         case ::ccdbusif::evolution::IF_UNKNOWN:
         default:
            ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): <unknown interface>",
                     opCodeVal,
                     ETG_ENUM(TRC_BTSGenIpc2BtsOpcode, opcode)));
            break;
      }
   }

#else

   for(size_t i = 0; i < properties.size(); i++)
   {
      switch(interface)
      {
         //#####################################################################
         case ::ccdbusif::evolution::IF_ADAPTER:
            switch(properties[i].propData.getType())
            {
               case ::ccdbusif::VARIANT_INT8:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum),
                           properties[i].propData.getInt8()));
                  break;
               case ::ccdbusif::VARIANT_UINT8:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%u",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum),
                           properties[i].propData.getUInt8()));
                  break;
               case ::ccdbusif::VARIANT_INT16:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum),
                           properties[i].propData.getInt16()));
                  break;
               case ::ccdbusif::VARIANT_UINT16:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%u",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum),
                           properties[i].propData.getUInt16()));
                  break;
               case ::ccdbusif::VARIANT_INT32:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum),
                           properties[i].propData.getInt32()));
                  break;
               case ::ccdbusif::VARIANT_UINT32:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%u",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum),
                           properties[i].propData.getUInt32()));
                  break;
               case ::ccdbusif::VARIANT_INT64:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%lld",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum),
                           properties[i].propData.getInt64()));
                  break;
               case ::ccdbusif::VARIANT_UINT64:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%llu",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum),
                           properties[i].propData.getUInt64()));
                  break;
               case ::ccdbusif::VARIANT_ENUM:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum),
                           properties[i].propData.getEnum()));
                  break;
               case ::ccdbusif::VARIANT_BOOL:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum),
                           properties[i].propData.getBool()));
                  break;
               case ::ccdbusif::VARIANT_STRING:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%s",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum),
                           properties[i].propData.getString().c_str()));
                  break;
               case ::ccdbusif::VARIANT_STRING_ARRAY:
                  for(size_t j = 0; j < properties[i].propData.getStringArray().size(); j++)
                  {
                     BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u][%u]: %s=%s",
                              opCodeVal,
                              getGenIpc2BtsOpcode2String(opcode),
                              i,
                              j,
                              ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum),
                              properties[i].propData.getStringArray()[j].c_str()));
                  }
                  break;
               case ::ccdbusif::VARIANT_UNKNOWN:
               default:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=<unknown type>",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getAdapterProperty2String(properties[i].propEnum)));
                  break;
            }
            break;
         //#####################################################################
         case ::ccdbusif::evolution::IF_DEVICE:
            switch(properties[i].propData.getType())
            {
               case ::ccdbusif::VARIANT_INT8:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum),
                           properties[i].propData.getInt8()));
                  break;
               case ::ccdbusif::VARIANT_UINT8:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%u",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum),
                           properties[i].propData.getUInt8()));
                  break;
               case ::ccdbusif::VARIANT_INT16:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum),
                           properties[i].propData.getInt16()));
                  break;
               case ::ccdbusif::VARIANT_UINT16:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%u",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum),
                           properties[i].propData.getUInt16()));
                  break;
               case ::ccdbusif::VARIANT_INT32:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum),
                           properties[i].propData.getInt32()));
                  break;
               case ::ccdbusif::VARIANT_UINT32:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%u",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum),
                           properties[i].propData.getUInt32()));
                  break;
               case ::ccdbusif::VARIANT_INT64:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%lld",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum),
                           properties[i].propData.getInt64()));
                  break;
               case ::ccdbusif::VARIANT_UINT64:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%llu",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum),
                           properties[i].propData.getUInt64()));
                  break;
               case ::ccdbusif::VARIANT_ENUM:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum),
                           properties[i].propData.getEnum()));
                  break;
               case ::ccdbusif::VARIANT_BOOL:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum),
                           properties[i].propData.getBool()));
                  break;
               case ::ccdbusif::VARIANT_STRING:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%s",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum),
                           properties[i].propData.getString().c_str()));
                  break;
               case ::ccdbusif::VARIANT_STRING_ARRAY:
                  for(size_t j = 0; j < properties[i].propData.getStringArray().size(); j++)
                  {
                     BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u][%u]: %s=%s",
                              opCodeVal,
                              getGenIpc2BtsOpcode2String(opcode),
                              i,
                              j,
                              ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum),
                              properties[i].propData.getStringArray()[j].c_str()));
                  }
                  break;
               case ::ccdbusif::VARIANT_UNKNOWN:
               default:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=<unknown type>",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getDeviceProperty2String(properties[i].propEnum)));
                  break;
            }
            break;
         //#####################################################################
         case ::ccdbusif::evolution::IF_SERVICE:
            switch(properties[i].propData.getType())
            {
               case ::ccdbusif::VARIANT_INT8:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum),
                           properties[i].propData.getInt8()));
                  break;
               case ::ccdbusif::VARIANT_UINT8:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%u",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum),
                           properties[i].propData.getUInt8()));
                  break;
               case ::ccdbusif::VARIANT_INT16:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum),
                           properties[i].propData.getInt16()));
                  break;
               case ::ccdbusif::VARIANT_UINT16:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%u",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum),
                           properties[i].propData.getUInt16()));
                  break;
               case ::ccdbusif::VARIANT_INT32:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum),
                           properties[i].propData.getInt32()));
                  break;
               case ::ccdbusif::VARIANT_UINT32:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%u",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum),
                           properties[i].propData.getUInt32()));
                  break;
               case ::ccdbusif::VARIANT_INT64:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%lld",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum),
                           properties[i].propData.getInt64()));
                  break;
               case ::ccdbusif::VARIANT_UINT64:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%llu",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum),
                           properties[i].propData.getUInt64()));
                  break;
               case ::ccdbusif::VARIANT_ENUM:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum),
                           properties[i].propData.getEnum()));
                  break;
               case ::ccdbusif::VARIANT_BOOL:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%d",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum),
                           properties[i].propData.getBool()));
                  break;
               case ::ccdbusif::VARIANT_STRING:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=%s",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum),
                           properties[i].propData.getString().c_str()));
                  break;
               case ::ccdbusif::VARIANT_STRING_ARRAY:
                  for(size_t j = 0; j < properties[i].propData.getStringArray().size(); j++)
                  {
                     BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u][%u]: %s=%s",
                              opCodeVal,
                              getGenIpc2BtsOpcode2String(opcode),
                              i,
                              j,
                              ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum),
                              properties[i].propData.getStringArray()[j].c_str()));
                  }
                  break;
               case ::ccdbusif::VARIANT_UNKNOWN:
               default:
                  BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): property[%u]: %s=<unknown type>",
                           opCodeVal,
                           getGenIpc2BtsOpcode2String(opcode),
                           i,
                           ::ccdbusif::evolution::getServiceProperty2String(properties[i].propEnum)));
                  break;
            }
            break;
         //#####################################################################
         case ::ccdbusif::evolution::IF_UNKNOWN:
         default:
            BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): <unknown interface>",
                     opCodeVal,
                     getGenIpc2BtsOpcode2String(opcode)));
            break;
      }
   }

#endif
}

} //genivi
} //btstackif
