/**
 * @file Ipc2Bts_Telephony_GEN.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages for function block BTS_FB_TELEPHONY.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_TELEPHONY.
 */

#include "Ipc2Bts_Telephony_GEN.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

Ipc2Bts_ServiceAvailabilityTelephony::Ipc2Bts_ServiceAvailabilityTelephony()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_ServiceAvailabilityTelephony))
{
   _interface = BTS_GEN_DBUS_SERVICE_LAST;
   _availabilityEvent = BTS_DBUS_SERVICE_LAST;
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_ServiceAvailabilityTelephony::Ipc2Bts_ServiceAvailabilityTelephony(IN const Ipc2Bts_ServiceAvailabilityTelephony& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _interface = ref._interface;
   _availabilityEvent = ref._availabilityEvent;
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Ipc2Bts_ServiceAvailabilityTelephony& Ipc2Bts_ServiceAvailabilityTelephony::operator=(IN const Ipc2Bts_ServiceAvailabilityTelephony& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _interface = ref._interface;
   _availabilityEvent = ref._availabilityEvent;
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_ServiceAvailabilityTelephony::~Ipc2Bts_ServiceAvailabilityTelephony()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ServiceAvailabilityTelephony::clone(void) const
{
   return new Ipc2Bts_ServiceAvailabilityTelephony(*this);
}

Ipc2Bts_AddHfpInterfaceObjectPathMapping::Ipc2Bts_AddHfpInterfaceObjectPathMapping()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_AddHfpInterfaceObjectPathMapping))
{
   _interface = ::ccdbusif::evolution::IF_UNKNOWN;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_AddHfpInterfaceObjectPathMapping::Ipc2Bts_AddHfpInterfaceObjectPathMapping(IN const Ipc2Bts_AddHfpInterfaceObjectPathMapping& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _interface = ref._interface;
   _objPath = ref._objPath;
}

Ipc2Bts_AddHfpInterfaceObjectPathMapping& Ipc2Bts_AddHfpInterfaceObjectPathMapping::operator=(IN const Ipc2Bts_AddHfpInterfaceObjectPathMapping& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _interface = ref._interface;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_AddHfpInterfaceObjectPathMapping::~Ipc2Bts_AddHfpInterfaceObjectPathMapping()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AddHfpInterfaceObjectPathMapping::clone(void) const
{
   return new Ipc2Bts_AddHfpInterfaceObjectPathMapping(*this);
}

Ipc2Bts_DelHfpInterfaceObjectPathMapping::Ipc2Bts_DelHfpInterfaceObjectPathMapping()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_DelHfpInterfaceObjectPathMapping))
{
   _interface = ::ccdbusif::evolution::IF_UNKNOWN;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_DelHfpInterfaceObjectPathMapping::Ipc2Bts_DelHfpInterfaceObjectPathMapping(IN const Ipc2Bts_DelHfpInterfaceObjectPathMapping& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _interface = ref._interface;
   _objPath = ref._objPath;
}

Ipc2Bts_DelHfpInterfaceObjectPathMapping& Ipc2Bts_DelHfpInterfaceObjectPathMapping::operator=(IN const Ipc2Bts_DelHfpInterfaceObjectPathMapping& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _interface = ref._interface;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_DelHfpInterfaceObjectPathMapping::~Ipc2Bts_DelHfpInterfaceObjectPathMapping()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DelHfpInterfaceObjectPathMapping::clone(void) const
{
   return new Ipc2Bts_DelHfpInterfaceObjectPathMapping(*this);
}

Ipc2Bts_GetHandsfreeProperties::Ipc2Bts_GetHandsfreeProperties()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_GetHandsfreeProperties))
{
   // _modem: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_GetHandsfreeProperties::Ipc2Bts_GetHandsfreeProperties(IN const Ipc2Bts_GetHandsfreeProperties& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _modem = ref._modem;
}

Ipc2Bts_GetHandsfreeProperties& Ipc2Bts_GetHandsfreeProperties::operator=(IN const Ipc2Bts_GetHandsfreeProperties& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _modem = ref._modem;

   return *this;
}

Ipc2Bts_GetHandsfreeProperties::~Ipc2Bts_GetHandsfreeProperties()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GetHandsfreeProperties::clone(void) const
{
   return new Ipc2Bts_GetHandsfreeProperties(*this);
}

Ipc2Bts_GetHandsfreePropertiesExt::Ipc2Bts_GetHandsfreePropertiesExt()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_GetHandsfreePropertiesExt))
{
   // _modem: init is done by member constructor
   // _properties is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_GetHandsfreePropertiesExt::Ipc2Bts_GetHandsfreePropertiesExt(IN const Ipc2Bts_GetHandsfreePropertiesExt& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _modem = ref._modem;
   _properties = ref._properties;
}

Ipc2Bts_GetHandsfreePropertiesExt& Ipc2Bts_GetHandsfreePropertiesExt::operator=(IN const Ipc2Bts_GetHandsfreePropertiesExt& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _modem = ref._modem;
   _properties = ref._properties;

   return *this;
}

Ipc2Bts_GetHandsfreePropertiesExt::~Ipc2Bts_GetHandsfreePropertiesExt()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GetHandsfreePropertiesExt::clone(void) const
{
   return new Ipc2Bts_GetHandsfreePropertiesExt(*this);
}

Ipc2Bts_HandsfreeFeaturesUpdate::Ipc2Bts_HandsfreeFeaturesUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_HandsfreeFeaturesUpdate))
{
   // _features: init is done by member constructor
   // _modem: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_HandsfreeFeaturesUpdate::Ipc2Bts_HandsfreeFeaturesUpdate(IN const Ipc2Bts_HandsfreeFeaturesUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _features = ref._features;
   _modem = ref._modem;
}

Ipc2Bts_HandsfreeFeaturesUpdate& Ipc2Bts_HandsfreeFeaturesUpdate::operator=(IN const Ipc2Bts_HandsfreeFeaturesUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _features = ref._features;
   _modem = ref._modem;

   return *this;
}

Ipc2Bts_HandsfreeFeaturesUpdate::~Ipc2Bts_HandsfreeFeaturesUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_HandsfreeFeaturesUpdate::clone(void) const
{
   return new Ipc2Bts_HandsfreeFeaturesUpdate(*this);
}

Ipc2Bts_HandsfreeInbandRingingUpdate::Ipc2Bts_HandsfreeInbandRingingUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_HandsfreeInbandRingingUpdate))
{
   _inbandRingingEnabled = false;
   // _modem: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_HandsfreeInbandRingingUpdate::Ipc2Bts_HandsfreeInbandRingingUpdate(IN const Ipc2Bts_HandsfreeInbandRingingUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _inbandRingingEnabled = ref._inbandRingingEnabled;
   _modem = ref._modem;
}

Ipc2Bts_HandsfreeInbandRingingUpdate& Ipc2Bts_HandsfreeInbandRingingUpdate::operator=(IN const Ipc2Bts_HandsfreeInbandRingingUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _inbandRingingEnabled = ref._inbandRingingEnabled;
   _modem = ref._modem;

   return *this;
}

Ipc2Bts_HandsfreeInbandRingingUpdate::~Ipc2Bts_HandsfreeInbandRingingUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_HandsfreeInbandRingingUpdate::clone(void) const
{
   return new Ipc2Bts_HandsfreeInbandRingingUpdate(*this);
}

Ipc2Bts_GetModems::Ipc2Bts_GetModems()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_GetModems))
{
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_GetModems::Ipc2Bts_GetModems(IN const Ipc2Bts_GetModems& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_GetModems& Ipc2Bts_GetModems::operator=(IN const Ipc2Bts_GetModems& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_GetModems::~Ipc2Bts_GetModems()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GetModems::clone(void) const
{
   return new Ipc2Bts_GetModems(*this);
}

Ipc2Bts_GetModemsExt::Ipc2Bts_GetModemsExt()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_GetModemsExt))
{
   // _modems is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_GetModemsExt::Ipc2Bts_GetModemsExt(IN const Ipc2Bts_GetModemsExt& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _modems = ref._modems;
}

Ipc2Bts_GetModemsExt& Ipc2Bts_GetModemsExt::operator=(IN const Ipc2Bts_GetModemsExt& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _modems = ref._modems;

   return *this;
}

Ipc2Bts_GetModemsExt::~Ipc2Bts_GetModemsExt()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GetModemsExt::clone(void) const
{
   return new Ipc2Bts_GetModemsExt(*this);
}

Ipc2Bts_ModemAdded::Ipc2Bts_ModemAdded()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_ModemAdded))
{
   // _modem: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_ModemAdded::Ipc2Bts_ModemAdded(IN const Ipc2Bts_ModemAdded& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _modem = ref._modem;
}

Ipc2Bts_ModemAdded& Ipc2Bts_ModemAdded::operator=(IN const Ipc2Bts_ModemAdded& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _modem = ref._modem;

   return *this;
}

Ipc2Bts_ModemAdded::~Ipc2Bts_ModemAdded()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ModemAdded::clone(void) const
{
   return new Ipc2Bts_ModemAdded(*this);
}

Ipc2Bts_ModemAddedExt::Ipc2Bts_ModemAddedExt()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_ModemAddedExt))
{
   // _modem: init is done by member constructor
   // _properties is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_ModemAddedExt::Ipc2Bts_ModemAddedExt(IN const Ipc2Bts_ModemAddedExt& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _modem = ref._modem;
   _properties = ref._properties;
}

Ipc2Bts_ModemAddedExt& Ipc2Bts_ModemAddedExt::operator=(IN const Ipc2Bts_ModemAddedExt& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _modem = ref._modem;
   _properties = ref._properties;

   return *this;
}

Ipc2Bts_ModemAddedExt::~Ipc2Bts_ModemAddedExt()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ModemAddedExt::clone(void) const
{
   return new Ipc2Bts_ModemAddedExt(*this);
}

Ipc2Bts_ModemRemoved::Ipc2Bts_ModemRemoved()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_ModemRemoved))
{
   // _modem: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_ModemRemoved::Ipc2Bts_ModemRemoved(IN const Ipc2Bts_ModemRemoved& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _modem = ref._modem;
}

Ipc2Bts_ModemRemoved& Ipc2Bts_ModemRemoved::operator=(IN const Ipc2Bts_ModemRemoved& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _modem = ref._modem;

   return *this;
}

Ipc2Bts_ModemRemoved::~Ipc2Bts_ModemRemoved()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ModemRemoved::clone(void) const
{
   return new Ipc2Bts_ModemRemoved(*this);
}

Ipc2Bts_GetModemProperties::Ipc2Bts_GetModemProperties()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_GetModemProperties))
{
   // _modem: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_GetModemProperties::Ipc2Bts_GetModemProperties(IN const Ipc2Bts_GetModemProperties& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _modem = ref._modem;
}

Ipc2Bts_GetModemProperties& Ipc2Bts_GetModemProperties::operator=(IN const Ipc2Bts_GetModemProperties& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _modem = ref._modem;

   return *this;
}

Ipc2Bts_GetModemProperties::~Ipc2Bts_GetModemProperties()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GetModemProperties::clone(void) const
{
   return new Ipc2Bts_GetModemProperties(*this);
}

Ipc2Bts_GetModemPropertiesExt::Ipc2Bts_GetModemPropertiesExt()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_GetModemPropertiesExt))
{
   // _modem: init is done by member constructor
   // _properties is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_GetModemPropertiesExt::Ipc2Bts_GetModemPropertiesExt(IN const Ipc2Bts_GetModemPropertiesExt& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _modem = ref._modem;
   _properties = ref._properties;
}

Ipc2Bts_GetModemPropertiesExt& Ipc2Bts_GetModemPropertiesExt::operator=(IN const Ipc2Bts_GetModemPropertiesExt& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _modem = ref._modem;
   _properties = ref._properties;

   return *this;
}

Ipc2Bts_GetModemPropertiesExt::~Ipc2Bts_GetModemPropertiesExt()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GetModemPropertiesExt::clone(void) const
{
   return new Ipc2Bts_GetModemPropertiesExt(*this);
}

Ipc2Bts_ModemInterfacesUpdate::Ipc2Bts_ModemInterfacesUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Ipc2BtsOC_ModemInterfacesUpdate))
{
   // _interfaces is empty per default
   // _modem: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_TELEPHONY);
}

Ipc2Bts_ModemInterfacesUpdate::Ipc2Bts_ModemInterfacesUpdate(IN const Ipc2Bts_ModemInterfacesUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _interfaces = ref._interfaces;
   _modem = ref._modem;
}

Ipc2Bts_ModemInterfacesUpdate& Ipc2Bts_ModemInterfacesUpdate::operator=(IN const Ipc2Bts_ModemInterfacesUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _interfaces = ref._interfaces;
   _modem = ref._modem;

   return *this;
}

Ipc2Bts_ModemInterfacesUpdate::~Ipc2Bts_ModemInterfacesUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ModemInterfacesUpdate::clone(void) const
{
   return new Ipc2Bts_ModemInterfacesUpdate(*this);
}

} //genivi
} //btstackif
