/**
 * @file Ipc2Bts_Phonebook_GEN.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages for function block BTS_FB_PHONEBOOK.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_PHONEBOOK.
 */

#include "Ipc2Bts_Phonebook_GEN.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

Ipc2Bts_ServiceAvailabilityPhonebook::Ipc2Bts_ServiceAvailabilityPhonebook()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_ServiceAvailabilityPhonebook))
{
   _interface = BTS_GEN_DBUS_SERVICE_LAST;
   _availabilityEvent = BTS_DBUS_SERVICE_LAST;
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_ServiceAvailabilityPhonebook::Ipc2Bts_ServiceAvailabilityPhonebook(IN const Ipc2Bts_ServiceAvailabilityPhonebook& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _interface = ref._interface;
   _availabilityEvent = ref._availabilityEvent;
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Ipc2Bts_ServiceAvailabilityPhonebook& Ipc2Bts_ServiceAvailabilityPhonebook::operator=(IN const Ipc2Bts_ServiceAvailabilityPhonebook& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _interface = ref._interface;
   _availabilityEvent = ref._availabilityEvent;
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_ServiceAvailabilityPhonebook::~Ipc2Bts_ServiceAvailabilityPhonebook()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ServiceAvailabilityPhonebook::clone(void) const
{
   return new Ipc2Bts_ServiceAvailabilityPhonebook(*this);
}

Ipc2Bts_PimSessionSourceUpdate::Ipc2Bts_PimSessionSourceUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimSessionSourceUpdate))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimSessionSourceUpdate::Ipc2Bts_PimSessionSourceUpdate(IN const Ipc2Bts_PimSessionSourceUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_PimSessionSourceUpdate& Ipc2Bts_PimSessionSourceUpdate::operator=(IN const Ipc2Bts_PimSessionSourceUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimSessionSourceUpdate::~Ipc2Bts_PimSessionSourceUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimSessionSourceUpdate::clone(void) const
{
   return new Ipc2Bts_PimSessionSourceUpdate(*this);
}

Ipc2Bts_PimSessionDestinationUpdate::Ipc2Bts_PimSessionDestinationUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimSessionDestinationUpdate))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimSessionDestinationUpdate::Ipc2Bts_PimSessionDestinationUpdate(IN const Ipc2Bts_PimSessionDestinationUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_PimSessionDestinationUpdate& Ipc2Bts_PimSessionDestinationUpdate::operator=(IN const Ipc2Bts_PimSessionDestinationUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimSessionDestinationUpdate::~Ipc2Bts_PimSessionDestinationUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimSessionDestinationUpdate::clone(void) const
{
   return new Ipc2Bts_PimSessionDestinationUpdate(*this);
}

Ipc2Bts_PimSessionChannelUpdate::Ipc2Bts_PimSessionChannelUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimSessionChannelUpdate))
{
   _channel = 0;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimSessionChannelUpdate::Ipc2Bts_PimSessionChannelUpdate(IN const Ipc2Bts_PimSessionChannelUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _channel = ref._channel;
   _objPath = ref._objPath;
}

Ipc2Bts_PimSessionChannelUpdate& Ipc2Bts_PimSessionChannelUpdate::operator=(IN const Ipc2Bts_PimSessionChannelUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _channel = ref._channel;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimSessionChannelUpdate::~Ipc2Bts_PimSessionChannelUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimSessionChannelUpdate::clone(void) const
{
   return new Ipc2Bts_PimSessionChannelUpdate(*this);
}

Ipc2Bts_PimSessionTargetUpdate::Ipc2Bts_PimSessionTargetUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimSessionTargetUpdate))
{
   // _target: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimSessionTargetUpdate::Ipc2Bts_PimSessionTargetUpdate(IN const Ipc2Bts_PimSessionTargetUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _target = ref._target;
   _objPath = ref._objPath;
}

Ipc2Bts_PimSessionTargetUpdate& Ipc2Bts_PimSessionTargetUpdate::operator=(IN const Ipc2Bts_PimSessionTargetUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _target = ref._target;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimSessionTargetUpdate::~Ipc2Bts_PimSessionTargetUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimSessionTargetUpdate::clone(void) const
{
   return new Ipc2Bts_PimSessionTargetUpdate(*this);
}

Ipc2Bts_PimTransferCancelResult::Ipc2Bts_PimTransferCancelResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimTransferCancelResult))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimTransferCancelResult::Ipc2Bts_PimTransferCancelResult(IN const Ipc2Bts_PimTransferCancelResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_PimTransferCancelResult& Ipc2Bts_PimTransferCancelResult::operator=(IN const Ipc2Bts_PimTransferCancelResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimTransferCancelResult::~Ipc2Bts_PimTransferCancelResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimTransferCancelResult::clone(void) const
{
   return new Ipc2Bts_PimTransferCancelResult(*this);
}

Ipc2Bts_PimTransferStatusUpdate::Ipc2Bts_PimTransferStatusUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimTransferStatusUpdate))
{
   _status = BTS_TRANSFER_STATUS_LAST;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimTransferStatusUpdate::Ipc2Bts_PimTransferStatusUpdate(IN const Ipc2Bts_PimTransferStatusUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _objPath = ref._objPath;
}

Ipc2Bts_PimTransferStatusUpdate& Ipc2Bts_PimTransferStatusUpdate::operator=(IN const Ipc2Bts_PimTransferStatusUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimTransferStatusUpdate::~Ipc2Bts_PimTransferStatusUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimTransferStatusUpdate::clone(void) const
{
   return new Ipc2Bts_PimTransferStatusUpdate(*this);
}

Ipc2Bts_PimTransferSessionUpdate::Ipc2Bts_PimTransferSessionUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimTransferSessionUpdate))
{
   // _session: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimTransferSessionUpdate::Ipc2Bts_PimTransferSessionUpdate(IN const Ipc2Bts_PimTransferSessionUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _session = ref._session;
   _objPath = ref._objPath;
}

Ipc2Bts_PimTransferSessionUpdate& Ipc2Bts_PimTransferSessionUpdate::operator=(IN const Ipc2Bts_PimTransferSessionUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _session = ref._session;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimTransferSessionUpdate::~Ipc2Bts_PimTransferSessionUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimTransferSessionUpdate::clone(void) const
{
   return new Ipc2Bts_PimTransferSessionUpdate(*this);
}

Ipc2Bts_PimTransferNameUpdate::Ipc2Bts_PimTransferNameUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimTransferNameUpdate))
{
   // _name: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimTransferNameUpdate::Ipc2Bts_PimTransferNameUpdate(IN const Ipc2Bts_PimTransferNameUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _name = ref._name;
   _objPath = ref._objPath;
}

Ipc2Bts_PimTransferNameUpdate& Ipc2Bts_PimTransferNameUpdate::operator=(IN const Ipc2Bts_PimTransferNameUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _name = ref._name;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimTransferNameUpdate::~Ipc2Bts_PimTransferNameUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimTransferNameUpdate::clone(void) const
{
   return new Ipc2Bts_PimTransferNameUpdate(*this);
}

Ipc2Bts_PimTransferTypeUpdate::Ipc2Bts_PimTransferTypeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimTransferTypeUpdate))
{
   // _type: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimTransferTypeUpdate::Ipc2Bts_PimTransferTypeUpdate(IN const Ipc2Bts_PimTransferTypeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _type = ref._type;
   _objPath = ref._objPath;
}

Ipc2Bts_PimTransferTypeUpdate& Ipc2Bts_PimTransferTypeUpdate::operator=(IN const Ipc2Bts_PimTransferTypeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _type = ref._type;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimTransferTypeUpdate::~Ipc2Bts_PimTransferTypeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimTransferTypeUpdate::clone(void) const
{
   return new Ipc2Bts_PimTransferTypeUpdate(*this);
}

Ipc2Bts_PimTransferTimeUpdate::Ipc2Bts_PimTransferTimeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimTransferTimeUpdate))
{
   _time = 0;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimTransferTimeUpdate::Ipc2Bts_PimTransferTimeUpdate(IN const Ipc2Bts_PimTransferTimeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _time = ref._time;
   _objPath = ref._objPath;
}

Ipc2Bts_PimTransferTimeUpdate& Ipc2Bts_PimTransferTimeUpdate::operator=(IN const Ipc2Bts_PimTransferTimeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _time = ref._time;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimTransferTimeUpdate::~Ipc2Bts_PimTransferTimeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimTransferTimeUpdate::clone(void) const
{
   return new Ipc2Bts_PimTransferTimeUpdate(*this);
}

Ipc2Bts_PimTransferSizeUpdate::Ipc2Bts_PimTransferSizeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimTransferSizeUpdate))
{
   _size = 0;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimTransferSizeUpdate::Ipc2Bts_PimTransferSizeUpdate(IN const Ipc2Bts_PimTransferSizeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _size = ref._size;
   _objPath = ref._objPath;
}

Ipc2Bts_PimTransferSizeUpdate& Ipc2Bts_PimTransferSizeUpdate::operator=(IN const Ipc2Bts_PimTransferSizeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _size = ref._size;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimTransferSizeUpdate::~Ipc2Bts_PimTransferSizeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimTransferSizeUpdate::clone(void) const
{
   return new Ipc2Bts_PimTransferSizeUpdate(*this);
}

Ipc2Bts_PimTransferTransferredUpdate::Ipc2Bts_PimTransferTransferredUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimTransferTransferredUpdate))
{
   _transferred = 0;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimTransferTransferredUpdate::Ipc2Bts_PimTransferTransferredUpdate(IN const Ipc2Bts_PimTransferTransferredUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _transferred = ref._transferred;
   _objPath = ref._objPath;
}

Ipc2Bts_PimTransferTransferredUpdate& Ipc2Bts_PimTransferTransferredUpdate::operator=(IN const Ipc2Bts_PimTransferTransferredUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _transferred = ref._transferred;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimTransferTransferredUpdate::~Ipc2Bts_PimTransferTransferredUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimTransferTransferredUpdate::clone(void) const
{
   return new Ipc2Bts_PimTransferTransferredUpdate(*this);
}

Ipc2Bts_PimTransferFilenameUpdate::Ipc2Bts_PimTransferFilenameUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Ipc2BtsOC_PimTransferFilenameUpdate))
{
   // _filename: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_PHONEBOOK);
}

Ipc2Bts_PimTransferFilenameUpdate::Ipc2Bts_PimTransferFilenameUpdate(IN const Ipc2Bts_PimTransferFilenameUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _filename = ref._filename;
   _objPath = ref._objPath;
}

Ipc2Bts_PimTransferFilenameUpdate& Ipc2Bts_PimTransferFilenameUpdate::operator=(IN const Ipc2Bts_PimTransferFilenameUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _filename = ref._filename;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_PimTransferFilenameUpdate::~Ipc2Bts_PimTransferFilenameUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PimTransferFilenameUpdate::clone(void) const
{
   return new Ipc2Bts_PimTransferFilenameUpdate(*this);
}

} //genivi
} //btstackif
