/**
 * @file Ipc2Bts_Messaging_GEN.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages for function block BTS_FB_MESSAGING.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_MESSAGING.
 */

#include "Ipc2Bts_Messaging_GEN.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

Ipc2Bts_ServiceAvailabilityMessaging::Ipc2Bts_ServiceAvailabilityMessaging()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_ServiceAvailabilityMessaging))
{
   _interface = BTS_GEN_DBUS_SERVICE_LAST;
   _availabilityEvent = BTS_DBUS_SERVICE_LAST;
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_ServiceAvailabilityMessaging::Ipc2Bts_ServiceAvailabilityMessaging(IN const Ipc2Bts_ServiceAvailabilityMessaging& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _interface = ref._interface;
   _availabilityEvent = ref._availabilityEvent;
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Ipc2Bts_ServiceAvailabilityMessaging& Ipc2Bts_ServiceAvailabilityMessaging::operator=(IN const Ipc2Bts_ServiceAvailabilityMessaging& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _interface = ref._interface;
   _availabilityEvent = ref._availabilityEvent;
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_ServiceAvailabilityMessaging::~Ipc2Bts_ServiceAvailabilityMessaging()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ServiceAvailabilityMessaging::clone(void) const
{
   return new Ipc2Bts_ServiceAvailabilityMessaging(*this);
}

Ipc2Bts_MsgSessionSourceUpdate::Ipc2Bts_MsgSessionSourceUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgSessionSourceUpdate))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgSessionSourceUpdate::Ipc2Bts_MsgSessionSourceUpdate(IN const Ipc2Bts_MsgSessionSourceUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_MsgSessionSourceUpdate& Ipc2Bts_MsgSessionSourceUpdate::operator=(IN const Ipc2Bts_MsgSessionSourceUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgSessionSourceUpdate::~Ipc2Bts_MsgSessionSourceUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgSessionSourceUpdate::clone(void) const
{
   return new Ipc2Bts_MsgSessionSourceUpdate(*this);
}

Ipc2Bts_MsgSessionDestinationUpdate::Ipc2Bts_MsgSessionDestinationUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgSessionDestinationUpdate))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgSessionDestinationUpdate::Ipc2Bts_MsgSessionDestinationUpdate(IN const Ipc2Bts_MsgSessionDestinationUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_MsgSessionDestinationUpdate& Ipc2Bts_MsgSessionDestinationUpdate::operator=(IN const Ipc2Bts_MsgSessionDestinationUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgSessionDestinationUpdate::~Ipc2Bts_MsgSessionDestinationUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgSessionDestinationUpdate::clone(void) const
{
   return new Ipc2Bts_MsgSessionDestinationUpdate(*this);
}

Ipc2Bts_MsgSessionChannelUpdate::Ipc2Bts_MsgSessionChannelUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgSessionChannelUpdate))
{
   _channel = 0;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgSessionChannelUpdate::Ipc2Bts_MsgSessionChannelUpdate(IN const Ipc2Bts_MsgSessionChannelUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _channel = ref._channel;
   _objPath = ref._objPath;
}

Ipc2Bts_MsgSessionChannelUpdate& Ipc2Bts_MsgSessionChannelUpdate::operator=(IN const Ipc2Bts_MsgSessionChannelUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _channel = ref._channel;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgSessionChannelUpdate::~Ipc2Bts_MsgSessionChannelUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgSessionChannelUpdate::clone(void) const
{
   return new Ipc2Bts_MsgSessionChannelUpdate(*this);
}

Ipc2Bts_MsgSessionTargetUpdate::Ipc2Bts_MsgSessionTargetUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgSessionTargetUpdate))
{
   // _target: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgSessionTargetUpdate::Ipc2Bts_MsgSessionTargetUpdate(IN const Ipc2Bts_MsgSessionTargetUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _target = ref._target;
   _objPath = ref._objPath;
}

Ipc2Bts_MsgSessionTargetUpdate& Ipc2Bts_MsgSessionTargetUpdate::operator=(IN const Ipc2Bts_MsgSessionTargetUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _target = ref._target;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgSessionTargetUpdate::~Ipc2Bts_MsgSessionTargetUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgSessionTargetUpdate::clone(void) const
{
   return new Ipc2Bts_MsgSessionTargetUpdate(*this);
}

Ipc2Bts_MsgTransferCancelResult::Ipc2Bts_MsgTransferCancelResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgTransferCancelResult))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgTransferCancelResult::Ipc2Bts_MsgTransferCancelResult(IN const Ipc2Bts_MsgTransferCancelResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_MsgTransferCancelResult& Ipc2Bts_MsgTransferCancelResult::operator=(IN const Ipc2Bts_MsgTransferCancelResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgTransferCancelResult::~Ipc2Bts_MsgTransferCancelResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgTransferCancelResult::clone(void) const
{
   return new Ipc2Bts_MsgTransferCancelResult(*this);
}

Ipc2Bts_MsgTransferStatusUpdate::Ipc2Bts_MsgTransferStatusUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgTransferStatusUpdate))
{
   _status = BTS_TRANSFER_STATUS_LAST;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgTransferStatusUpdate::Ipc2Bts_MsgTransferStatusUpdate(IN const Ipc2Bts_MsgTransferStatusUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _objPath = ref._objPath;
}

Ipc2Bts_MsgTransferStatusUpdate& Ipc2Bts_MsgTransferStatusUpdate::operator=(IN const Ipc2Bts_MsgTransferStatusUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgTransferStatusUpdate::~Ipc2Bts_MsgTransferStatusUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgTransferStatusUpdate::clone(void) const
{
   return new Ipc2Bts_MsgTransferStatusUpdate(*this);
}

Ipc2Bts_MsgTransferSessionUpdate::Ipc2Bts_MsgTransferSessionUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgTransferSessionUpdate))
{
   // _session: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgTransferSessionUpdate::Ipc2Bts_MsgTransferSessionUpdate(IN const Ipc2Bts_MsgTransferSessionUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _session = ref._session;
   _objPath = ref._objPath;
}

Ipc2Bts_MsgTransferSessionUpdate& Ipc2Bts_MsgTransferSessionUpdate::operator=(IN const Ipc2Bts_MsgTransferSessionUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _session = ref._session;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgTransferSessionUpdate::~Ipc2Bts_MsgTransferSessionUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgTransferSessionUpdate::clone(void) const
{
   return new Ipc2Bts_MsgTransferSessionUpdate(*this);
}

Ipc2Bts_MsgTransferNameUpdate::Ipc2Bts_MsgTransferNameUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgTransferNameUpdate))
{
   // _name: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgTransferNameUpdate::Ipc2Bts_MsgTransferNameUpdate(IN const Ipc2Bts_MsgTransferNameUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _name = ref._name;
   _objPath = ref._objPath;
}

Ipc2Bts_MsgTransferNameUpdate& Ipc2Bts_MsgTransferNameUpdate::operator=(IN const Ipc2Bts_MsgTransferNameUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _name = ref._name;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgTransferNameUpdate::~Ipc2Bts_MsgTransferNameUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgTransferNameUpdate::clone(void) const
{
   return new Ipc2Bts_MsgTransferNameUpdate(*this);
}

Ipc2Bts_MsgTransferTypeUpdate::Ipc2Bts_MsgTransferTypeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgTransferTypeUpdate))
{
   // _type: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgTransferTypeUpdate::Ipc2Bts_MsgTransferTypeUpdate(IN const Ipc2Bts_MsgTransferTypeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _type = ref._type;
   _objPath = ref._objPath;
}

Ipc2Bts_MsgTransferTypeUpdate& Ipc2Bts_MsgTransferTypeUpdate::operator=(IN const Ipc2Bts_MsgTransferTypeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _type = ref._type;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgTransferTypeUpdate::~Ipc2Bts_MsgTransferTypeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgTransferTypeUpdate::clone(void) const
{
   return new Ipc2Bts_MsgTransferTypeUpdate(*this);
}

Ipc2Bts_MsgTransferTimeUpdate::Ipc2Bts_MsgTransferTimeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgTransferTimeUpdate))
{
   _time = 0;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgTransferTimeUpdate::Ipc2Bts_MsgTransferTimeUpdate(IN const Ipc2Bts_MsgTransferTimeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _time = ref._time;
   _objPath = ref._objPath;
}

Ipc2Bts_MsgTransferTimeUpdate& Ipc2Bts_MsgTransferTimeUpdate::operator=(IN const Ipc2Bts_MsgTransferTimeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _time = ref._time;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgTransferTimeUpdate::~Ipc2Bts_MsgTransferTimeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgTransferTimeUpdate::clone(void) const
{
   return new Ipc2Bts_MsgTransferTimeUpdate(*this);
}

Ipc2Bts_MsgTransferSizeUpdate::Ipc2Bts_MsgTransferSizeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgTransferSizeUpdate))
{
   _size = 0;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgTransferSizeUpdate::Ipc2Bts_MsgTransferSizeUpdate(IN const Ipc2Bts_MsgTransferSizeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _size = ref._size;
   _objPath = ref._objPath;
}

Ipc2Bts_MsgTransferSizeUpdate& Ipc2Bts_MsgTransferSizeUpdate::operator=(IN const Ipc2Bts_MsgTransferSizeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _size = ref._size;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgTransferSizeUpdate::~Ipc2Bts_MsgTransferSizeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgTransferSizeUpdate::clone(void) const
{
   return new Ipc2Bts_MsgTransferSizeUpdate(*this);
}

Ipc2Bts_MsgTransferTransferredUpdate::Ipc2Bts_MsgTransferTransferredUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgTransferTransferredUpdate))
{
   _transferred = 0;
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgTransferTransferredUpdate::Ipc2Bts_MsgTransferTransferredUpdate(IN const Ipc2Bts_MsgTransferTransferredUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _transferred = ref._transferred;
   _objPath = ref._objPath;
}

Ipc2Bts_MsgTransferTransferredUpdate& Ipc2Bts_MsgTransferTransferredUpdate::operator=(IN const Ipc2Bts_MsgTransferTransferredUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _transferred = ref._transferred;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgTransferTransferredUpdate::~Ipc2Bts_MsgTransferTransferredUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgTransferTransferredUpdate::clone(void) const
{
   return new Ipc2Bts_MsgTransferTransferredUpdate(*this);
}

Ipc2Bts_MsgTransferFilenameUpdate::Ipc2Bts_MsgTransferFilenameUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Ipc2BtsOC_MsgTransferFilenameUpdate))
{
   // _filename: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MESSAGING);
}

Ipc2Bts_MsgTransferFilenameUpdate::Ipc2Bts_MsgTransferFilenameUpdate(IN const Ipc2Bts_MsgTransferFilenameUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _filename = ref._filename;
   _objPath = ref._objPath;
}

Ipc2Bts_MsgTransferFilenameUpdate& Ipc2Bts_MsgTransferFilenameUpdate::operator=(IN const Ipc2Bts_MsgTransferFilenameUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _filename = ref._filename;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_MsgTransferFilenameUpdate::~Ipc2Bts_MsgTransferFilenameUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_MsgTransferFilenameUpdate::clone(void) const
{
   return new Ipc2Bts_MsgTransferFilenameUpdate(*this);
}

} //genivi
} //btstackif
