/**
 * @file Ipc2Bts_Phonebook_GEN.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages for function block BTS_FB_PHONEBOOK.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_PHONEBOOK.
 */

#ifndef _IPC_2_BTS_PHONEBOOK_MSG_GENIVI_H_
#define _IPC_2_BTS_PHONEBOOK_MSG_GENIVI_H_

#include "EvolutionGeniviStackTypes.h"
#include "Ipc2Bts_BaseMessage.h"

namespace btstackif {
namespace genivi {

/**
 *
 */
class Ipc2Bts_ServiceAvailabilityPhonebook : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ServiceAvailabilityPhonebook();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ServiceAvailabilityPhonebook(IN const Ipc2Bts_ServiceAvailabilityPhonebook& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ServiceAvailabilityPhonebook& operator=(IN const Ipc2Bts_ServiceAvailabilityPhonebook& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ServiceAvailabilityPhonebook();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInterface(IN const BTSGenDbusServiceInterface interface) { _interface = interface; }
   inline void setAvailabilityEvent(IN const BTSDbusServiceAvailability availabilityEvent) { _availabilityEvent = availabilityEvent; }
   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSGenDbusServiceInterface getInterface(void) const { return _interface; }
   inline BTSDbusServiceAvailability getAvailabilityEvent(void) const { return _availabilityEvent; }
   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSGenDbusServiceInterface _interface; /**< parameter interface */
   BTSDbusServiceAvailability _availabilityEvent; /**< parameter availability event */
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimSessionSourceUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimSessionSourceUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimSessionSourceUpdate(IN const Ipc2Bts_PimSessionSourceUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimSessionSourceUpdate& operator=(IN const Ipc2Bts_PimSessionSourceUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimSessionSourceUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimSessionDestinationUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimSessionDestinationUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimSessionDestinationUpdate(IN const Ipc2Bts_PimSessionDestinationUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimSessionDestinationUpdate& operator=(IN const Ipc2Bts_PimSessionDestinationUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimSessionDestinationUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimSessionChannelUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimSessionChannelUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimSessionChannelUpdate(IN const Ipc2Bts_PimSessionChannelUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimSessionChannelUpdate& operator=(IN const Ipc2Bts_PimSessionChannelUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimSessionChannelUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setChannel(IN const BTSSessionChannel channel) { _channel = channel; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSSessionChannel getChannel(void) const { return _channel; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSSessionChannel _channel; /**< parameter channel */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimSessionTargetUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimSessionTargetUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimSessionTargetUpdate(IN const Ipc2Bts_PimSessionTargetUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimSessionTargetUpdate& operator=(IN const Ipc2Bts_PimSessionTargetUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimSessionTargetUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setTarget(IN const BTSUuid& target) { _target = target; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getTarget(OUT BTSUuid& target) const { target = _target; }
   inline const BTSUuid& getTarget(void) const { return _target; }
   inline BTSUuid& getTargetMutable(void) { return _target; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSUuid _target; /**< parameter target */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimTransferCancelResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimTransferCancelResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimTransferCancelResult(IN const Ipc2Bts_PimTransferCancelResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimTransferCancelResult& operator=(IN const Ipc2Bts_PimTransferCancelResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimTransferCancelResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimTransferStatusUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimTransferStatusUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimTransferStatusUpdate(IN const Ipc2Bts_PimTransferStatusUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimTransferStatusUpdate& operator=(IN const Ipc2Bts_PimTransferStatusUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimTransferStatusUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSTransferStatus status) { _status = status; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSTransferStatus getStatus(void) const { return _status; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSTransferStatus _status; /**< parameter status */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimTransferSessionUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimTransferSessionUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimTransferSessionUpdate(IN const Ipc2Bts_PimTransferSessionUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimTransferSessionUpdate& operator=(IN const Ipc2Bts_PimTransferSessionUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimTransferSessionUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setSession(IN const BTSObjectPath& session) { _session = session; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getSession(OUT BTSObjectPath& session) const { session = _session; }
   inline const BTSObjectPath& getSession(void) const { return _session; }
   inline BTSObjectPath& getSessionMutable(void) { return _session; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _session; /**< parameter session */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimTransferNameUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimTransferNameUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimTransferNameUpdate(IN const Ipc2Bts_PimTransferNameUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimTransferNameUpdate& operator=(IN const Ipc2Bts_PimTransferNameUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimTransferNameUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setName(IN const BTSTransferName& name) { _name = name; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getName(OUT BTSTransferName& name) const { name = _name; }
   inline const BTSTransferName& getName(void) const { return _name; }
   inline BTSTransferName& getNameMutable(void) { return _name; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSTransferName _name; /**< parameter name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimTransferTypeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimTransferTypeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimTransferTypeUpdate(IN const Ipc2Bts_PimTransferTypeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimTransferTypeUpdate& operator=(IN const Ipc2Bts_PimTransferTypeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimTransferTypeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setType(IN const BTSTransferType& type) { _type = type; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getType(OUT BTSTransferType& type) const { type = _type; }
   inline const BTSTransferType& getType(void) const { return _type; }
   inline BTSTransferType& getTypeMutable(void) { return _type; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSTransferType _type; /**< parameter type */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimTransferTimeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimTransferTimeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimTransferTimeUpdate(IN const Ipc2Bts_PimTransferTimeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimTransferTimeUpdate& operator=(IN const Ipc2Bts_PimTransferTimeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimTransferTimeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setTime(IN const BTSTransferTime time) { _time = time; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSTransferTime getTime(void) const { return _time; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSTransferTime _time; /**< parameter time */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimTransferSizeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimTransferSizeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimTransferSizeUpdate(IN const Ipc2Bts_PimTransferSizeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimTransferSizeUpdate& operator=(IN const Ipc2Bts_PimTransferSizeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimTransferSizeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setSize(IN const BTSTransferSize size) { _size = size; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSTransferSize getSize(void) const { return _size; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSTransferSize _size; /**< parameter size */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimTransferTransferredUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimTransferTransferredUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimTransferTransferredUpdate(IN const Ipc2Bts_PimTransferTransferredUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimTransferTransferredUpdate& operator=(IN const Ipc2Bts_PimTransferTransferredUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimTransferTransferredUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setTransferred(IN const BTSTransferSize transferred) { _transferred = transferred; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSTransferSize getTransferred(void) const { return _transferred; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSTransferSize _transferred; /**< parameter transferred */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_PimTransferFilenameUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PimTransferFilenameUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PimTransferFilenameUpdate(IN const Ipc2Bts_PimTransferFilenameUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PimTransferFilenameUpdate& operator=(IN const Ipc2Bts_PimTransferFilenameUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PimTransferFilenameUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setFilename(IN const BTSFilename& filename) { _filename = filename; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getFilename(OUT BTSFilename& filename) const { filename = _filename; }
   inline const BTSFilename& getFilename(void) const { return _filename; }
   inline BTSFilename& getFilenameMutable(void) { return _filename; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSFilename _filename; /**< parameter filename */
   BTSObjectPath _objPath; /**< parameter obj path */
};

} //genivi
} //btstackif

#endif //_IPC_2_BTS_PHONEBOOK_MSG_GENIVI_H_
