/**
 * @file Ipc2Bts_Messaging_GEN.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages for function block BTS_FB_MESSAGING.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_MESSAGING.
 */

#ifndef _IPC_2_BTS_MESSAGING_MSG_GENIVI_H_
#define _IPC_2_BTS_MESSAGING_MSG_GENIVI_H_

#include "EvolutionGeniviStackTypes.h"
#include "Ipc2Bts_BaseMessage.h"

namespace btstackif {
namespace genivi {

/**
 *
 */
class Ipc2Bts_ServiceAvailabilityMessaging : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ServiceAvailabilityMessaging();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ServiceAvailabilityMessaging(IN const Ipc2Bts_ServiceAvailabilityMessaging& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ServiceAvailabilityMessaging& operator=(IN const Ipc2Bts_ServiceAvailabilityMessaging& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ServiceAvailabilityMessaging();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInterface(IN const BTSGenDbusServiceInterface interface) { _interface = interface; }
   inline void setAvailabilityEvent(IN const BTSDbusServiceAvailability availabilityEvent) { _availabilityEvent = availabilityEvent; }
   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSGenDbusServiceInterface getInterface(void) const { return _interface; }
   inline BTSDbusServiceAvailability getAvailabilityEvent(void) const { return _availabilityEvent; }
   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSGenDbusServiceInterface _interface; /**< parameter interface */
   BTSDbusServiceAvailability _availabilityEvent; /**< parameter availability event */
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgSessionSourceUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgSessionSourceUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgSessionSourceUpdate(IN const Ipc2Bts_MsgSessionSourceUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgSessionSourceUpdate& operator=(IN const Ipc2Bts_MsgSessionSourceUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgSessionSourceUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgSessionDestinationUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgSessionDestinationUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgSessionDestinationUpdate(IN const Ipc2Bts_MsgSessionDestinationUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgSessionDestinationUpdate& operator=(IN const Ipc2Bts_MsgSessionDestinationUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgSessionDestinationUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgSessionChannelUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgSessionChannelUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgSessionChannelUpdate(IN const Ipc2Bts_MsgSessionChannelUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgSessionChannelUpdate& operator=(IN const Ipc2Bts_MsgSessionChannelUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgSessionChannelUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setChannel(IN const BTSSessionChannel channel) { _channel = channel; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSSessionChannel getChannel(void) const { return _channel; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSSessionChannel _channel; /**< parameter channel */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgSessionTargetUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgSessionTargetUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgSessionTargetUpdate(IN const Ipc2Bts_MsgSessionTargetUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgSessionTargetUpdate& operator=(IN const Ipc2Bts_MsgSessionTargetUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgSessionTargetUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setTarget(IN const BTSUuid& target) { _target = target; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getTarget(OUT BTSUuid& target) const { target = _target; }
   inline const BTSUuid& getTarget(void) const { return _target; }
   inline BTSUuid& getTargetMutable(void) { return _target; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSUuid _target; /**< parameter target */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgTransferCancelResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgTransferCancelResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgTransferCancelResult(IN const Ipc2Bts_MsgTransferCancelResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgTransferCancelResult& operator=(IN const Ipc2Bts_MsgTransferCancelResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgTransferCancelResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgTransferStatusUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgTransferStatusUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgTransferStatusUpdate(IN const Ipc2Bts_MsgTransferStatusUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgTransferStatusUpdate& operator=(IN const Ipc2Bts_MsgTransferStatusUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgTransferStatusUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSTransferStatus status) { _status = status; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSTransferStatus getStatus(void) const { return _status; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSTransferStatus _status; /**< parameter status */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgTransferSessionUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgTransferSessionUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgTransferSessionUpdate(IN const Ipc2Bts_MsgTransferSessionUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgTransferSessionUpdate& operator=(IN const Ipc2Bts_MsgTransferSessionUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgTransferSessionUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setSession(IN const BTSObjectPath& session) { _session = session; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getSession(OUT BTSObjectPath& session) const { session = _session; }
   inline const BTSObjectPath& getSession(void) const { return _session; }
   inline BTSObjectPath& getSessionMutable(void) { return _session; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _session; /**< parameter session */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgTransferNameUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgTransferNameUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgTransferNameUpdate(IN const Ipc2Bts_MsgTransferNameUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgTransferNameUpdate& operator=(IN const Ipc2Bts_MsgTransferNameUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgTransferNameUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setName(IN const BTSTransferName& name) { _name = name; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getName(OUT BTSTransferName& name) const { name = _name; }
   inline const BTSTransferName& getName(void) const { return _name; }
   inline BTSTransferName& getNameMutable(void) { return _name; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSTransferName _name; /**< parameter name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgTransferTypeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgTransferTypeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgTransferTypeUpdate(IN const Ipc2Bts_MsgTransferTypeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgTransferTypeUpdate& operator=(IN const Ipc2Bts_MsgTransferTypeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgTransferTypeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setType(IN const BTSTransferType& type) { _type = type; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getType(OUT BTSTransferType& type) const { type = _type; }
   inline const BTSTransferType& getType(void) const { return _type; }
   inline BTSTransferType& getTypeMutable(void) { return _type; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSTransferType _type; /**< parameter type */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgTransferTimeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgTransferTimeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgTransferTimeUpdate(IN const Ipc2Bts_MsgTransferTimeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgTransferTimeUpdate& operator=(IN const Ipc2Bts_MsgTransferTimeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgTransferTimeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setTime(IN const BTSTransferTime time) { _time = time; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSTransferTime getTime(void) const { return _time; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSTransferTime _time; /**< parameter time */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgTransferSizeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgTransferSizeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgTransferSizeUpdate(IN const Ipc2Bts_MsgTransferSizeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgTransferSizeUpdate& operator=(IN const Ipc2Bts_MsgTransferSizeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgTransferSizeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setSize(IN const BTSTransferSize size) { _size = size; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSTransferSize getSize(void) const { return _size; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSTransferSize _size; /**< parameter size */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgTransferTransferredUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgTransferTransferredUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgTransferTransferredUpdate(IN const Ipc2Bts_MsgTransferTransferredUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgTransferTransferredUpdate& operator=(IN const Ipc2Bts_MsgTransferTransferredUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgTransferTransferredUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setTransferred(IN const BTSTransferSize transferred) { _transferred = transferred; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSTransferSize getTransferred(void) const { return _transferred; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSTransferSize _transferred; /**< parameter transferred */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_MsgTransferFilenameUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_MsgTransferFilenameUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_MsgTransferFilenameUpdate(IN const Ipc2Bts_MsgTransferFilenameUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_MsgTransferFilenameUpdate& operator=(IN const Ipc2Bts_MsgTransferFilenameUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_MsgTransferFilenameUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setFilename(IN const BTSFilename& filename) { _filename = filename; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getFilename(OUT BTSFilename& filename) const { filename = _filename; }
   inline const BTSFilename& getFilename(void) const { return _filename; }
   inline BTSFilename& getFilenameMutable(void) { return _filename; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSFilename _filename; /**< parameter filename */
   BTSObjectPath _objPath; /**< parameter obj path */
};

} //genivi
} //btstackif

#endif //_IPC_2_BTS_MESSAGING_MSG_GENIVI_H_
