/**
 * @file Ipc2Bts_MessageWrapper_GEN.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief Wrapper for IPC to BtStackIf messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wrapper for IPC to BtStackIf messages.
 * The only reason for this file is to solve following lint warnings:
 * Warning 429: prio2: Custodial pointer 'ptrMessage' ...
 */

#ifndef _IPC_2_BTS_MESSAGE_WRAPPER_GENIVI_H_
#define _IPC_2_BTS_MESSAGE_WRAPPER_GENIVI_H_

#include "Ipc2Bts_Connection_GEN.h"
#include "Ipc2Bts_Telephony_GEN.h"
#include "Ipc2Bts_Phonebook_GEN.h"
#include "Ipc2Bts_Messaging_GEN.h"
#include "Ipc2Bts_MediaPlayer_GEN.h"

namespace btstackif {
namespace genivi {

inline Ipc2Bts_ServiceAvailabilityConnection* ptrNew_Ipc2Bts_ServiceAvailabilityConnection(void) { return new Ipc2Bts_ServiceAvailabilityConnection(); }
inline Ipc2Bts_GetAllPropertiesConnection* ptrNew_Ipc2Bts_GetAllPropertiesConnection(void) { return new Ipc2Bts_GetAllPropertiesConnection(); }
inline Ipc2Bts_AddDeviceObjectPathMapping* ptrNew_Ipc2Bts_AddDeviceObjectPathMapping(void) { return new Ipc2Bts_AddDeviceObjectPathMapping(); }
inline Ipc2Bts_DelDeviceObjectPathMapping* ptrNew_Ipc2Bts_DelDeviceObjectPathMapping(void) { return new Ipc2Bts_DelDeviceObjectPathMapping(); }
inline Ipc2Bts_AddProtocolObjectPathMapping* ptrNew_Ipc2Bts_AddProtocolObjectPathMapping(void) { return new Ipc2Bts_AddProtocolObjectPathMapping(); }
inline Ipc2Bts_DelProtocolObjectPathMapping* ptrNew_Ipc2Bts_DelProtocolObjectPathMapping(void) { return new Ipc2Bts_DelProtocolObjectPathMapping(); }
inline Ipc2Bts_AddSerialObjectPathMapping* ptrNew_Ipc2Bts_AddSerialObjectPathMapping(void) { return new Ipc2Bts_AddSerialObjectPathMapping(); }
inline Ipc2Bts_DelSerialObjectPathMapping* ptrNew_Ipc2Bts_DelSerialObjectPathMapping(void) { return new Ipc2Bts_DelSerialObjectPathMapping(); }
inline Ipc2Bts_Release* ptrNew_Ipc2Bts_Release(void) { return new Ipc2Bts_Release(); }
inline Ipc2Bts_RequestPinCode* ptrNew_Ipc2Bts_RequestPinCode(void) { return new Ipc2Bts_RequestPinCode(); }
inline Ipc2Bts_DisplayPinCode* ptrNew_Ipc2Bts_DisplayPinCode(void) { return new Ipc2Bts_DisplayPinCode(); }
inline Ipc2Bts_RequestPasskey* ptrNew_Ipc2Bts_RequestPasskey(void) { return new Ipc2Bts_RequestPasskey(); }
inline Ipc2Bts_RequestConfirmation* ptrNew_Ipc2Bts_RequestConfirmation(void) { return new Ipc2Bts_RequestConfirmation(); }
inline Ipc2Bts_Cancel* ptrNew_Ipc2Bts_Cancel(void) { return new Ipc2Bts_Cancel(); }
inline Ipc2Bts_CancelRequest* ptrNew_Ipc2Bts_CancelRequest(void) { return new Ipc2Bts_CancelRequest(); }
inline Ipc2Bts_AuthorizeService* ptrNew_Ipc2Bts_AuthorizeService(void) { return new Ipc2Bts_AuthorizeService(); }
inline Ipc2Bts_RequestAuthorization* ptrNew_Ipc2Bts_RequestAuthorization(void) { return new Ipc2Bts_RequestAuthorization(); }
inline Ipc2Bts_RequestLinkkey* ptrNew_Ipc2Bts_RequestLinkkey(void) { return new Ipc2Bts_RequestLinkkey(); }
inline Ipc2Bts_DisplayPasskey* ptrNew_Ipc2Bts_DisplayPasskey(void) { return new Ipc2Bts_DisplayPasskey(); }
inline Ipc2Bts_StartDiscoveryResult* ptrNew_Ipc2Bts_StartDiscoveryResult(void) { return new Ipc2Bts_StartDiscoveryResult(); }
inline Ipc2Bts_StopDiscoveryResult* ptrNew_Ipc2Bts_StopDiscoveryResult(void) { return new Ipc2Bts_StopDiscoveryResult(); }
inline Ipc2Bts_RemoveDeviceResult* ptrNew_Ipc2Bts_RemoveDeviceResult(void) { return new Ipc2Bts_RemoveDeviceResult(); }
inline Ipc2Bts_CreateDeviceResult* ptrNew_Ipc2Bts_CreateDeviceResult(void) { return new Ipc2Bts_CreateDeviceResult(); }
inline Ipc2Bts_SendHCICmdResult* ptrNew_Ipc2Bts_SendHCICmdResult(void) { return new Ipc2Bts_SendHCICmdResult(); }
inline Ipc2Bts_AdapterInitialization* ptrNew_Ipc2Bts_AdapterInitialization(void) { return new Ipc2Bts_AdapterInitialization(); }
inline Ipc2Bts_DeviceCreated* ptrNew_Ipc2Bts_DeviceCreated(void) { return new Ipc2Bts_DeviceCreated(); }
inline Ipc2Bts_DeviceRemoved* ptrNew_Ipc2Bts_DeviceRemoved(void) { return new Ipc2Bts_DeviceRemoved(); }
inline Ipc2Bts_BtStackLog* ptrNew_Ipc2Bts_BtStackLog(void) { return new Ipc2Bts_BtStackLog(); }
inline Ipc2Bts_HCIEvent* ptrNew_Ipc2Bts_HCIEvent(void) { return new Ipc2Bts_HCIEvent(); }
inline Ipc2Bts_DeviceFound* ptrNew_Ipc2Bts_DeviceFound(void) { return new Ipc2Bts_DeviceFound(); }
inline Ipc2Bts_AdapterAddressUpdate* ptrNew_Ipc2Bts_AdapterAddressUpdate(void) { return new Ipc2Bts_AdapterAddressUpdate(); }
inline Ipc2Bts_AdapterClassUpdate* ptrNew_Ipc2Bts_AdapterClassUpdate(void) { return new Ipc2Bts_AdapterClassUpdate(); }
inline Ipc2Bts_AdapterAliasUpdate* ptrNew_Ipc2Bts_AdapterAliasUpdate(void) { return new Ipc2Bts_AdapterAliasUpdate(); }
inline Ipc2Bts_AdapterPoweredUpdate* ptrNew_Ipc2Bts_AdapterPoweredUpdate(void) { return new Ipc2Bts_AdapterPoweredUpdate(); }
inline Ipc2Bts_AdapterDiscoverableUpdate* ptrNew_Ipc2Bts_AdapterDiscoverableUpdate(void) { return new Ipc2Bts_AdapterDiscoverableUpdate(); }
inline Ipc2Bts_AdapterDiscoverabletimeoutUpdate* ptrNew_Ipc2Bts_AdapterDiscoverabletimeoutUpdate(void) { return new Ipc2Bts_AdapterDiscoverabletimeoutUpdate(); }
inline Ipc2Bts_AdapterPairableUpdate* ptrNew_Ipc2Bts_AdapterPairableUpdate(void) { return new Ipc2Bts_AdapterPairableUpdate(); }
inline Ipc2Bts_AdapterPairabletimeoutUpdate* ptrNew_Ipc2Bts_AdapterPairabletimeoutUpdate(void) { return new Ipc2Bts_AdapterPairabletimeoutUpdate(); }
inline Ipc2Bts_AdapterDiscoveringUpdate* ptrNew_Ipc2Bts_AdapterDiscoveringUpdate(void) { return new Ipc2Bts_AdapterDiscoveringUpdate(); }
inline Ipc2Bts_AdapterUuidsUpdate* ptrNew_Ipc2Bts_AdapterUuidsUpdate(void) { return new Ipc2Bts_AdapterUuidsUpdate(); }
inline Ipc2Bts_AdapterWbsModeUpdate* ptrNew_Ipc2Bts_AdapterWbsModeUpdate(void) { return new Ipc2Bts_AdapterWbsModeUpdate(); }
inline Ipc2Bts_AdapterConnectableUpdate* ptrNew_Ipc2Bts_AdapterConnectableUpdate(void) { return new Ipc2Bts_AdapterConnectableUpdate(); }
inline Ipc2Bts_AdapterHcimodeUpdate* ptrNew_Ipc2Bts_AdapterHcimodeUpdate(void) { return new Ipc2Bts_AdapterHcimodeUpdate(); }
inline Ipc2Bts_AdapterVersionUpdate* ptrNew_Ipc2Bts_AdapterVersionUpdate(void) { return new Ipc2Bts_AdapterVersionUpdate(); }
inline Ipc2Bts_AdapterTraceLevelUpdate* ptrNew_Ipc2Bts_AdapterTraceLevelUpdate(void) { return new Ipc2Bts_AdapterTraceLevelUpdate(); }
inline Ipc2Bts_AdapterTraceCategoryUpdate* ptrNew_Ipc2Bts_AdapterTraceCategoryUpdate(void) { return new Ipc2Bts_AdapterTraceCategoryUpdate(); }
inline Ipc2Bts_AdapterAvailableSppServersUpdate* ptrNew_Ipc2Bts_AdapterAvailableSppServersUpdate(void) { return new Ipc2Bts_AdapterAvailableSppServersUpdate(); }
inline Ipc2Bts_RegisterAgentResult* ptrNew_Ipc2Bts_RegisterAgentResult(void) { return new Ipc2Bts_RegisterAgentResult(); }
inline Ipc2Bts_UnregisterAgentResult* ptrNew_Ipc2Bts_UnregisterAgentResult(void) { return new Ipc2Bts_UnregisterAgentResult(); }
inline Ipc2Bts_RequestDefaultAgentResult* ptrNew_Ipc2Bts_RequestDefaultAgentResult(void) { return new Ipc2Bts_RequestDefaultAgentResult(); }
inline Ipc2Bts_DeviceConnectResult* ptrNew_Ipc2Bts_DeviceConnectResult(void) { return new Ipc2Bts_DeviceConnectResult(); }
inline Ipc2Bts_DeviceDisconnectResult* ptrNew_Ipc2Bts_DeviceDisconnectResult(void) { return new Ipc2Bts_DeviceDisconnectResult(); }
inline Ipc2Bts_PairResult* ptrNew_Ipc2Bts_PairResult(void) { return new Ipc2Bts_PairResult(); }
inline Ipc2Bts_CancelPairingResult* ptrNew_Ipc2Bts_CancelPairingResult(void) { return new Ipc2Bts_CancelPairingResult(); }
inline Ipc2Bts_DiscoverServicesResult* ptrNew_Ipc2Bts_DiscoverServicesResult(void) { return new Ipc2Bts_DiscoverServicesResult(); }
inline Ipc2Bts_CancelDiscoveryResult* ptrNew_Ipc2Bts_CancelDiscoveryResult(void) { return new Ipc2Bts_CancelDiscoveryResult(); }
inline Ipc2Bts_ReportLinkkey* ptrNew_Ipc2Bts_ReportLinkkey(void) { return new Ipc2Bts_ReportLinkkey(); }
inline Ipc2Bts_IncomingPairingComp* ptrNew_Ipc2Bts_IncomingPairingComp(void) { return new Ipc2Bts_IncomingPairingComp(); }
inline Ipc2Bts_SDPProcessReport* ptrNew_Ipc2Bts_SDPProcessReport(void) { return new Ipc2Bts_SDPProcessReport(); }
inline Ipc2Bts_DeviceAddressUpdate* ptrNew_Ipc2Bts_DeviceAddressUpdate(void) { return new Ipc2Bts_DeviceAddressUpdate(); }
inline Ipc2Bts_DeviceClassUpdate* ptrNew_Ipc2Bts_DeviceClassUpdate(void) { return new Ipc2Bts_DeviceClassUpdate(); }
inline Ipc2Bts_DeviceIconUpdate* ptrNew_Ipc2Bts_DeviceIconUpdate(void) { return new Ipc2Bts_DeviceIconUpdate(); }
inline Ipc2Bts_DeviceUuidsUpdate* ptrNew_Ipc2Bts_DeviceUuidsUpdate(void) { return new Ipc2Bts_DeviceUuidsUpdate(); }
inline Ipc2Bts_DevicePairedUpdate* ptrNew_Ipc2Bts_DevicePairedUpdate(void) { return new Ipc2Bts_DevicePairedUpdate(); }
inline Ipc2Bts_DeviceConnectedUpdate* ptrNew_Ipc2Bts_DeviceConnectedUpdate(void) { return new Ipc2Bts_DeviceConnectedUpdate(); }
inline Ipc2Bts_DeviceTrustedUpdate* ptrNew_Ipc2Bts_DeviceTrustedUpdate(void) { return new Ipc2Bts_DeviceTrustedUpdate(); }
inline Ipc2Bts_DeviceBlockedUpdate* ptrNew_Ipc2Bts_DeviceBlockedUpdate(void) { return new Ipc2Bts_DeviceBlockedUpdate(); }
inline Ipc2Bts_DeviceAliasUpdate* ptrNew_Ipc2Bts_DeviceAliasUpdate(void) { return new Ipc2Bts_DeviceAliasUpdate(); }
inline Ipc2Bts_DeviceAdapterUpdate* ptrNew_Ipc2Bts_DeviceAdapterUpdate(void) { return new Ipc2Bts_DeviceAdapterUpdate(); }
inline Ipc2Bts_DeviceModaliasUpdate* ptrNew_Ipc2Bts_DeviceModaliasUpdate(void) { return new Ipc2Bts_DeviceModaliasUpdate(); }
inline Ipc2Bts_DeviceRssiUpdate* ptrNew_Ipc2Bts_DeviceRssiUpdate(void) { return new Ipc2Bts_DeviceRssiUpdate(); }
inline Ipc2Bts_DeviceVendorIdUpdate* ptrNew_Ipc2Bts_DeviceVendorIdUpdate(void) { return new Ipc2Bts_DeviceVendorIdUpdate(); }
inline Ipc2Bts_DeviceVendorIdSourceUpdate* ptrNew_Ipc2Bts_DeviceVendorIdSourceUpdate(void) { return new Ipc2Bts_DeviceVendorIdSourceUpdate(); }
inline Ipc2Bts_DeviceProductIdUpdate* ptrNew_Ipc2Bts_DeviceProductIdUpdate(void) { return new Ipc2Bts_DeviceProductIdUpdate(); }
inline Ipc2Bts_DeviceMapInfoUpdate* ptrNew_Ipc2Bts_DeviceMapInfoUpdate(void) { return new Ipc2Bts_DeviceMapInfoUpdate(); }
inline Ipc2Bts_DeviceConnectedServiceUpdate* ptrNew_Ipc2Bts_DeviceConnectedServiceUpdate(void) { return new Ipc2Bts_DeviceConnectedServiceUpdate(); }
inline Ipc2Bts_DeviceVersionUpdate* ptrNew_Ipc2Bts_DeviceVersionUpdate(void) { return new Ipc2Bts_DeviceVersionUpdate(); }
inline Ipc2Bts_DevicePbapInfoUpdate* ptrNew_Ipc2Bts_DevicePbapInfoUpdate(void) { return new Ipc2Bts_DevicePbapInfoUpdate(); }
inline Ipc2Bts_DeviceModeUpdate* ptrNew_Ipc2Bts_DeviceModeUpdate(void) { return new Ipc2Bts_DeviceModeUpdate(); }
inline Ipc2Bts_DeviceRoleUpdate* ptrNew_Ipc2Bts_DeviceRoleUpdate(void) { return new Ipc2Bts_DeviceRoleUpdate(); }
inline Ipc2Bts_DeviceEnableAvpPauseUpdate* ptrNew_Ipc2Bts_DeviceEnableAvpPauseUpdate(void) { return new Ipc2Bts_DeviceEnableAvpPauseUpdate(); }
inline Ipc2Bts_BtApplDeviceConnectReqResult* ptrNew_Ipc2Bts_BtApplDeviceConnectReqResult(void) { return new Ipc2Bts_BtApplDeviceConnectReqResult(); }
inline Ipc2Bts_BtApplDeviceDisconnectReqResult* ptrNew_Ipc2Bts_BtApplDeviceDisconnectReqResult(void) { return new Ipc2Bts_BtApplDeviceDisconnectReqResult(); }
inline Ipc2Bts_BtApplCancelConnectReqResult* ptrNew_Ipc2Bts_BtApplCancelConnectReqResult(void) { return new Ipc2Bts_BtApplCancelConnectReqResult(); }
inline Ipc2Bts_BtApplGetHwVersionReqResult* ptrNew_Ipc2Bts_BtApplGetHwVersionReqResult(void) { return new Ipc2Bts_BtApplGetHwVersionReqResult(); }
inline Ipc2Bts_BtApplSetConfigurationReqResult* ptrNew_Ipc2Bts_BtApplSetConfigurationReqResult(void) { return new Ipc2Bts_BtApplSetConfigurationReqResult(); }
inline Ipc2Bts_BtApplReadConfigurationReqResult* ptrNew_Ipc2Bts_BtApplReadConfigurationReqResult(void) { return new Ipc2Bts_BtApplReadConfigurationReqResult(); }
inline Ipc2Bts_BtApplTestModeReqResult* ptrNew_Ipc2Bts_BtApplTestModeReqResult(void) { return new Ipc2Bts_BtApplTestModeReqResult(); }
inline Ipc2Bts_BtApplTestModeLinkQualityReqResult* ptrNew_Ipc2Bts_BtApplTestModeLinkQualityReqResult(void) { return new Ipc2Bts_BtApplTestModeLinkQualityReqResult(); }
inline Ipc2Bts_BtApplDeviceConnectCfm* ptrNew_Ipc2Bts_BtApplDeviceConnectCfm(void) { return new Ipc2Bts_BtApplDeviceConnectCfm(); }
inline Ipc2Bts_BtApplDeviceConnectInd* ptrNew_Ipc2Bts_BtApplDeviceConnectInd(void) { return new Ipc2Bts_BtApplDeviceConnectInd(); }
inline Ipc2Bts_BtApplDeviceDisconnectCfm* ptrNew_Ipc2Bts_BtApplDeviceDisconnectCfm(void) { return new Ipc2Bts_BtApplDeviceDisconnectCfm(); }
inline Ipc2Bts_BtApplDeviceDisconnectInd* ptrNew_Ipc2Bts_BtApplDeviceDisconnectInd(void) { return new Ipc2Bts_BtApplDeviceDisconnectInd(); }
inline Ipc2Bts_BtApplDeviceDisconnectCompInd* ptrNew_Ipc2Bts_BtApplDeviceDisconnectCompInd(void) { return new Ipc2Bts_BtApplDeviceDisconnectCompInd(); }
inline Ipc2Bts_BtApplDeviceConnectCompInd* ptrNew_Ipc2Bts_BtApplDeviceConnectCompInd(void) { return new Ipc2Bts_BtApplDeviceConnectCompInd(); }
inline Ipc2Bts_BtApplCancelConnectCfm* ptrNew_Ipc2Bts_BtApplCancelConnectCfm(void) { return new Ipc2Bts_BtApplCancelConnectCfm(); }
inline Ipc2Bts_BtApplStatusNotificationInd* ptrNew_Ipc2Bts_BtApplStatusNotificationInd(void) { return new Ipc2Bts_BtApplStatusNotificationInd(); }
inline Ipc2Bts_BtApplGetHwVersionCfm* ptrNew_Ipc2Bts_BtApplGetHwVersionCfm(void) { return new Ipc2Bts_BtApplGetHwVersionCfm(); }
inline Ipc2Bts_BtApplSetConfigurationCfm* ptrNew_Ipc2Bts_BtApplSetConfigurationCfm(void) { return new Ipc2Bts_BtApplSetConfigurationCfm(); }
inline Ipc2Bts_BtApplReadConfigurationCfm* ptrNew_Ipc2Bts_BtApplReadConfigurationCfm(void) { return new Ipc2Bts_BtApplReadConfigurationCfm(); }
inline Ipc2Bts_BtApplTestModeCfm* ptrNew_Ipc2Bts_BtApplTestModeCfm(void) { return new Ipc2Bts_BtApplTestModeCfm(); }
inline Ipc2Bts_BtApplTestModeCompInd* ptrNew_Ipc2Bts_BtApplTestModeCompInd(void) { return new Ipc2Bts_BtApplTestModeCompInd(); }
inline Ipc2Bts_BtApplTestModeLinkQualityCfm* ptrNew_Ipc2Bts_BtApplTestModeLinkQualityCfm(void) { return new Ipc2Bts_BtApplTestModeLinkQualityCfm(); }
inline Ipc2Bts_ConnectResult* ptrNew_Ipc2Bts_ConnectResult(void) { return new Ipc2Bts_ConnectResult(); }
inline Ipc2Bts_DisconnectResult* ptrNew_Ipc2Bts_DisconnectResult(void) { return new Ipc2Bts_DisconnectResult(); }
inline Ipc2Bts_ServiceRemoteUuidUpdate* ptrNew_Ipc2Bts_ServiceRemoteUuidUpdate(void) { return new Ipc2Bts_ServiceRemoteUuidUpdate(); }
inline Ipc2Bts_ServiceStateUpdate* ptrNew_Ipc2Bts_ServiceStateUpdate(void) { return new Ipc2Bts_ServiceStateUpdate(); }
inline Ipc2Bts_ServiceDeviceUpdate* ptrNew_Ipc2Bts_ServiceDeviceUpdate(void) { return new Ipc2Bts_ServiceDeviceUpdate(); }
inline Ipc2Bts_ServiceVersionUpdate* ptrNew_Ipc2Bts_ServiceVersionUpdate(void) { return new Ipc2Bts_ServiceVersionUpdate(); }
inline Ipc2Bts_DebugTraceConfigResult* ptrNew_Ipc2Bts_DebugTraceConfigResult(void) { return new Ipc2Bts_DebugTraceConfigResult(); }
inline Ipc2Bts_ProtocolTraceConfigResult* ptrNew_Ipc2Bts_ProtocolTraceConfigResult(void) { return new Ipc2Bts_ProtocolTraceConfigResult(); }
inline Ipc2Bts_ReportDebugTrace* ptrNew_Ipc2Bts_ReportDebugTrace(void) { return new Ipc2Bts_ReportDebugTrace(); }
inline Ipc2Bts_ReportProtocolTrace* ptrNew_Ipc2Bts_ReportProtocolTrace(void) { return new Ipc2Bts_ReportProtocolTrace(); }
inline Ipc2Bts_FatalError* ptrNew_Ipc2Bts_FatalError(void) { return new Ipc2Bts_FatalError(); }
inline Ipc2Bts_GeneralError* ptrNew_Ipc2Bts_GeneralError(void) { return new Ipc2Bts_GeneralError(); }
inline Ipc2Bts_ReportGeniviDebugTrace* ptrNew_Ipc2Bts_ReportGeniviDebugTrace(void) { return new Ipc2Bts_ReportGeniviDebugTrace(); }
inline Ipc2Bts_GeniviFatalError* ptrNew_Ipc2Bts_GeniviFatalError(void) { return new Ipc2Bts_GeniviFatalError(); }
inline Ipc2Bts_BtApplDidSetReqResult* ptrNew_Ipc2Bts_BtApplDidSetReqResult(void) { return new Ipc2Bts_BtApplDidSetReqResult(); }
inline Ipc2Bts_BtApplDidSetCfm* ptrNew_Ipc2Bts_BtApplDidSetCfm(void) { return new Ipc2Bts_BtApplDidSetCfm(); }
inline Ipc2Bts_DunDeviceFilePathUpdate* ptrNew_Ipc2Bts_DunDeviceFilePathUpdate(void) { return new Ipc2Bts_DunDeviceFilePathUpdate(); }
inline Ipc2Bts_BtApplSppSetUuidReqResult* ptrNew_Ipc2Bts_BtApplSppSetUuidReqResult(void) { return new Ipc2Bts_BtApplSppSetUuidReqResult(); }
inline Ipc2Bts_BtApplSppSetUuidCfm* ptrNew_Ipc2Bts_BtApplSppSetUuidCfm(void) { return new Ipc2Bts_BtApplSppSetUuidCfm(); }
inline Ipc2Bts_BtApplSppVirtualDeviceInd* ptrNew_Ipc2Bts_BtApplSppVirtualDeviceInd(void) { return new Ipc2Bts_BtApplSppVirtualDeviceInd(); }
inline Ipc2Bts_CreateSessionResult* ptrNew_Ipc2Bts_CreateSessionResult(void) { return new Ipc2Bts_CreateSessionResult(); }
inline Ipc2Bts_RemoveSessionResult* ptrNew_Ipc2Bts_RemoveSessionResult(void) { return new Ipc2Bts_RemoveSessionResult(); }
inline Ipc2Bts_CancelSessionResult* ptrNew_Ipc2Bts_CancelSessionResult(void) { return new Ipc2Bts_CancelSessionResult(); }
inline Ipc2Bts_SessionCreated* ptrNew_Ipc2Bts_SessionCreated(void) { return new Ipc2Bts_SessionCreated(); }
inline Ipc2Bts_SessionRemoved* ptrNew_Ipc2Bts_SessionRemoved(void) { return new Ipc2Bts_SessionRemoved(); }
inline Ipc2Bts_AddTechnologyObjectPath* ptrNew_Ipc2Bts_AddTechnologyObjectPath(void) { return new Ipc2Bts_AddTechnologyObjectPath(); }
inline Ipc2Bts_DelTechnologyObjectPath* ptrNew_Ipc2Bts_DelTechnologyObjectPath(void) { return new Ipc2Bts_DelTechnologyObjectPath(); }
inline Ipc2Bts_AddNetworkObjectPathMapping* ptrNew_Ipc2Bts_AddNetworkObjectPathMapping(void) { return new Ipc2Bts_AddNetworkObjectPathMapping(); }
inline Ipc2Bts_DelNetworkObjectPathMapping* ptrNew_Ipc2Bts_DelNetworkObjectPathMapping(void) { return new Ipc2Bts_DelNetworkObjectPathMapping(); }
inline Ipc2Bts_GetConnManManagerPropertiesResult* ptrNew_Ipc2Bts_GetConnManManagerPropertiesResult(void) { return new Ipc2Bts_GetConnManManagerPropertiesResult(); }
inline Ipc2Bts_GetConnManTechnologiesResult* ptrNew_Ipc2Bts_GetConnManTechnologiesResult(void) { return new Ipc2Bts_GetConnManTechnologiesResult(); }
inline Ipc2Bts_GetConnManServicesResult* ptrNew_Ipc2Bts_GetConnManServicesResult(void) { return new Ipc2Bts_GetConnManServicesResult(); }
inline Ipc2Bts_ConnManTechnologyAdded* ptrNew_Ipc2Bts_ConnManTechnologyAdded(void) { return new Ipc2Bts_ConnManTechnologyAdded(); }
inline Ipc2Bts_ConnManTechnologyRemoved* ptrNew_Ipc2Bts_ConnManTechnologyRemoved(void) { return new Ipc2Bts_ConnManTechnologyRemoved(); }
inline Ipc2Bts_ConnManServicesChanged* ptrNew_Ipc2Bts_ConnManServicesChanged(void) { return new Ipc2Bts_ConnManServicesChanged(); }
inline Ipc2Bts_ConnManServicesRemoved* ptrNew_Ipc2Bts_ConnManServicesRemoved(void) { return new Ipc2Bts_ConnManServicesRemoved(); }
inline Ipc2Bts_GetConnManServicePropertiesResult* ptrNew_Ipc2Bts_GetConnManServicePropertiesResult(void) { return new Ipc2Bts_GetConnManServicePropertiesResult(); }
inline Ipc2Bts_ConnManServiceConnectResult* ptrNew_Ipc2Bts_ConnManServiceConnectResult(void) { return new Ipc2Bts_ConnManServiceConnectResult(); }
inline Ipc2Bts_ConnManServiceDisconnectResult* ptrNew_Ipc2Bts_ConnManServiceDisconnectResult(void) { return new Ipc2Bts_ConnManServiceDisconnectResult(); }
inline Ipc2Bts_ConnManServiceStateUpdate* ptrNew_Ipc2Bts_ConnManServiceStateUpdate(void) { return new Ipc2Bts_ConnManServiceStateUpdate(); }
inline Ipc2Bts_ConnManServiceInterfaceUpdate* ptrNew_Ipc2Bts_ConnManServiceInterfaceUpdate(void) { return new Ipc2Bts_ConnManServiceInterfaceUpdate(); }
inline Ipc2Bts_SerialDeviceFilePath* ptrNew_Ipc2Bts_SerialDeviceFilePath(void) { return new Ipc2Bts_SerialDeviceFilePath(); }
inline Ipc2Bts_CharacterDeviceAddedRemoved* ptrNew_Ipc2Bts_CharacterDeviceAddedRemoved(void) { return new Ipc2Bts_CharacterDeviceAddedRemoved(); }
inline Ipc2Bts_CreateLeDeviceResult* ptrNew_Ipc2Bts_CreateLeDeviceResult(void) { return new Ipc2Bts_CreateLeDeviceResult(); }
inline Ipc2Bts_RemoveLeDeviceResult* ptrNew_Ipc2Bts_RemoveLeDeviceResult(void) { return new Ipc2Bts_RemoveLeDeviceResult(); }
inline Ipc2Bts_LeAdapterInitialization* ptrNew_Ipc2Bts_LeAdapterInitialization(void) { return new Ipc2Bts_LeAdapterInitialization(); }
inline Ipc2Bts_LeDeviceCreated* ptrNew_Ipc2Bts_LeDeviceCreated(void) { return new Ipc2Bts_LeDeviceCreated(); }
inline Ipc2Bts_LeDeviceRemoved* ptrNew_Ipc2Bts_LeDeviceRemoved(void) { return new Ipc2Bts_LeDeviceRemoved(); }
inline Ipc2Bts_LeAdapterAddressTypeUpdate* ptrNew_Ipc2Bts_LeAdapterAddressTypeUpdate(void) { return new Ipc2Bts_LeAdapterAddressTypeUpdate(); }
inline Ipc2Bts_LeAdapterAddressUpdate* ptrNew_Ipc2Bts_LeAdapterAddressUpdate(void) { return new Ipc2Bts_LeAdapterAddressUpdate(); }
inline Ipc2Bts_LeAdapterAliasUpdate* ptrNew_Ipc2Bts_LeAdapterAliasUpdate(void) { return new Ipc2Bts_LeAdapterAliasUpdate(); }
inline Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate* ptrNew_Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate(void) { return new Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate(); }
inline Ipc2Bts_LeAdapterDiscoverableModeUpdate* ptrNew_Ipc2Bts_LeAdapterDiscoverableModeUpdate(void) { return new Ipc2Bts_LeAdapterDiscoverableModeUpdate(); }
inline Ipc2Bts_LeAdapterAdvertisingDataUpdate* ptrNew_Ipc2Bts_LeAdapterAdvertisingDataUpdate(void) { return new Ipc2Bts_LeAdapterAdvertisingDataUpdate(); }
inline Ipc2Bts_LeAdapterAdvertiseEnableUpdate* ptrNew_Ipc2Bts_LeAdapterAdvertiseEnableUpdate(void) { return new Ipc2Bts_LeAdapterAdvertiseEnableUpdate(); }
inline Ipc2Bts_AddLeDeviceObjectPathMapping* ptrNew_Ipc2Bts_AddLeDeviceObjectPathMapping(void) { return new Ipc2Bts_AddLeDeviceObjectPathMapping(); }
inline Ipc2Bts_DelLeDeviceObjectPathMapping* ptrNew_Ipc2Bts_DelLeDeviceObjectPathMapping(void) { return new Ipc2Bts_DelLeDeviceObjectPathMapping(); }
inline Ipc2Bts_LeDeviceDisconnectResult* ptrNew_Ipc2Bts_LeDeviceDisconnectResult(void) { return new Ipc2Bts_LeDeviceDisconnectResult(); }
inline Ipc2Bts_LeDisconnectionComp* ptrNew_Ipc2Bts_LeDisconnectionComp(void) { return new Ipc2Bts_LeDisconnectionComp(); }
inline Ipc2Bts_LeDeviceAddressTypeUpdate* ptrNew_Ipc2Bts_LeDeviceAddressTypeUpdate(void) { return new Ipc2Bts_LeDeviceAddressTypeUpdate(); }
inline Ipc2Bts_LeDeviceAddressUpdate* ptrNew_Ipc2Bts_LeDeviceAddressUpdate(void) { return new Ipc2Bts_LeDeviceAddressUpdate(); }
inline Ipc2Bts_LeDeviceConnectedUpdate* ptrNew_Ipc2Bts_LeDeviceConnectedUpdate(void) { return new Ipc2Bts_LeDeviceConnectedUpdate(); }
inline Ipc2Bts_SendSeamlessPairingErrorCodeResult* ptrNew_Ipc2Bts_SendSeamlessPairingErrorCodeResult(void) { return new Ipc2Bts_SendSeamlessPairingErrorCodeResult(); }
inline Ipc2Bts_SeamlessPairingAllowAccessResult* ptrNew_Ipc2Bts_SeamlessPairingAllowAccessResult(void) { return new Ipc2Bts_SeamlessPairingAllowAccessResult(); }
inline Ipc2Bts_SeamlessPairingErrorCodeReceived* ptrNew_Ipc2Bts_SeamlessPairingErrorCodeReceived(void) { return new Ipc2Bts_SeamlessPairingErrorCodeReceived(); }
inline Ipc2Bts_SeamlessPairingAccessRequest* ptrNew_Ipc2Bts_SeamlessPairingAccessRequest(void) { return new Ipc2Bts_SeamlessPairingAccessRequest(); }
inline Ipc2Bts_SeamlessPairingPairingDataUpdate* ptrNew_Ipc2Bts_SeamlessPairingPairingDataUpdate(void) { return new Ipc2Bts_SeamlessPairingPairingDataUpdate(); }
inline Ipc2Bts_ServiceAvailabilityTelephony* ptrNew_Ipc2Bts_ServiceAvailabilityTelephony(void) { return new Ipc2Bts_ServiceAvailabilityTelephony(); }
inline Ipc2Bts_AddHfpInterfaceObjectPathMapping* ptrNew_Ipc2Bts_AddHfpInterfaceObjectPathMapping(void) { return new Ipc2Bts_AddHfpInterfaceObjectPathMapping(); }
inline Ipc2Bts_DelHfpInterfaceObjectPathMapping* ptrNew_Ipc2Bts_DelHfpInterfaceObjectPathMapping(void) { return new Ipc2Bts_DelHfpInterfaceObjectPathMapping(); }
inline Ipc2Bts_GetHandsfreeProperties* ptrNew_Ipc2Bts_GetHandsfreeProperties(void) { return new Ipc2Bts_GetHandsfreeProperties(); }
inline Ipc2Bts_GetHandsfreePropertiesExt* ptrNew_Ipc2Bts_GetHandsfreePropertiesExt(void) { return new Ipc2Bts_GetHandsfreePropertiesExt(); }
inline Ipc2Bts_HandsfreeFeaturesUpdate* ptrNew_Ipc2Bts_HandsfreeFeaturesUpdate(void) { return new Ipc2Bts_HandsfreeFeaturesUpdate(); }
inline Ipc2Bts_HandsfreeInbandRingingUpdate* ptrNew_Ipc2Bts_HandsfreeInbandRingingUpdate(void) { return new Ipc2Bts_HandsfreeInbandRingingUpdate(); }
inline Ipc2Bts_GetModems* ptrNew_Ipc2Bts_GetModems(void) { return new Ipc2Bts_GetModems(); }
inline Ipc2Bts_GetModemsExt* ptrNew_Ipc2Bts_GetModemsExt(void) { return new Ipc2Bts_GetModemsExt(); }
inline Ipc2Bts_ModemAdded* ptrNew_Ipc2Bts_ModemAdded(void) { return new Ipc2Bts_ModemAdded(); }
inline Ipc2Bts_ModemAddedExt* ptrNew_Ipc2Bts_ModemAddedExt(void) { return new Ipc2Bts_ModemAddedExt(); }
inline Ipc2Bts_ModemRemoved* ptrNew_Ipc2Bts_ModemRemoved(void) { return new Ipc2Bts_ModemRemoved(); }
inline Ipc2Bts_GetModemProperties* ptrNew_Ipc2Bts_GetModemProperties(void) { return new Ipc2Bts_GetModemProperties(); }
inline Ipc2Bts_GetModemPropertiesExt* ptrNew_Ipc2Bts_GetModemPropertiesExt(void) { return new Ipc2Bts_GetModemPropertiesExt(); }
inline Ipc2Bts_ModemInterfacesUpdate* ptrNew_Ipc2Bts_ModemInterfacesUpdate(void) { return new Ipc2Bts_ModemInterfacesUpdate(); }
inline Ipc2Bts_ServiceAvailabilityPhonebook* ptrNew_Ipc2Bts_ServiceAvailabilityPhonebook(void) { return new Ipc2Bts_ServiceAvailabilityPhonebook(); }
inline Ipc2Bts_PimSessionSourceUpdate* ptrNew_Ipc2Bts_PimSessionSourceUpdate(void) { return new Ipc2Bts_PimSessionSourceUpdate(); }
inline Ipc2Bts_PimSessionDestinationUpdate* ptrNew_Ipc2Bts_PimSessionDestinationUpdate(void) { return new Ipc2Bts_PimSessionDestinationUpdate(); }
inline Ipc2Bts_PimSessionChannelUpdate* ptrNew_Ipc2Bts_PimSessionChannelUpdate(void) { return new Ipc2Bts_PimSessionChannelUpdate(); }
inline Ipc2Bts_PimSessionTargetUpdate* ptrNew_Ipc2Bts_PimSessionTargetUpdate(void) { return new Ipc2Bts_PimSessionTargetUpdate(); }
inline Ipc2Bts_PimTransferCancelResult* ptrNew_Ipc2Bts_PimTransferCancelResult(void) { return new Ipc2Bts_PimTransferCancelResult(); }
inline Ipc2Bts_PimTransferStatusUpdate* ptrNew_Ipc2Bts_PimTransferStatusUpdate(void) { return new Ipc2Bts_PimTransferStatusUpdate(); }
inline Ipc2Bts_PimTransferSessionUpdate* ptrNew_Ipc2Bts_PimTransferSessionUpdate(void) { return new Ipc2Bts_PimTransferSessionUpdate(); }
inline Ipc2Bts_PimTransferNameUpdate* ptrNew_Ipc2Bts_PimTransferNameUpdate(void) { return new Ipc2Bts_PimTransferNameUpdate(); }
inline Ipc2Bts_PimTransferTypeUpdate* ptrNew_Ipc2Bts_PimTransferTypeUpdate(void) { return new Ipc2Bts_PimTransferTypeUpdate(); }
inline Ipc2Bts_PimTransferTimeUpdate* ptrNew_Ipc2Bts_PimTransferTimeUpdate(void) { return new Ipc2Bts_PimTransferTimeUpdate(); }
inline Ipc2Bts_PimTransferSizeUpdate* ptrNew_Ipc2Bts_PimTransferSizeUpdate(void) { return new Ipc2Bts_PimTransferSizeUpdate(); }
inline Ipc2Bts_PimTransferTransferredUpdate* ptrNew_Ipc2Bts_PimTransferTransferredUpdate(void) { return new Ipc2Bts_PimTransferTransferredUpdate(); }
inline Ipc2Bts_PimTransferFilenameUpdate* ptrNew_Ipc2Bts_PimTransferFilenameUpdate(void) { return new Ipc2Bts_PimTransferFilenameUpdate(); }
inline Ipc2Bts_ServiceAvailabilityMessaging* ptrNew_Ipc2Bts_ServiceAvailabilityMessaging(void) { return new Ipc2Bts_ServiceAvailabilityMessaging(); }
inline Ipc2Bts_MsgSessionSourceUpdate* ptrNew_Ipc2Bts_MsgSessionSourceUpdate(void) { return new Ipc2Bts_MsgSessionSourceUpdate(); }
inline Ipc2Bts_MsgSessionDestinationUpdate* ptrNew_Ipc2Bts_MsgSessionDestinationUpdate(void) { return new Ipc2Bts_MsgSessionDestinationUpdate(); }
inline Ipc2Bts_MsgSessionChannelUpdate* ptrNew_Ipc2Bts_MsgSessionChannelUpdate(void) { return new Ipc2Bts_MsgSessionChannelUpdate(); }
inline Ipc2Bts_MsgSessionTargetUpdate* ptrNew_Ipc2Bts_MsgSessionTargetUpdate(void) { return new Ipc2Bts_MsgSessionTargetUpdate(); }
inline Ipc2Bts_MsgTransferCancelResult* ptrNew_Ipc2Bts_MsgTransferCancelResult(void) { return new Ipc2Bts_MsgTransferCancelResult(); }
inline Ipc2Bts_MsgTransferStatusUpdate* ptrNew_Ipc2Bts_MsgTransferStatusUpdate(void) { return new Ipc2Bts_MsgTransferStatusUpdate(); }
inline Ipc2Bts_MsgTransferSessionUpdate* ptrNew_Ipc2Bts_MsgTransferSessionUpdate(void) { return new Ipc2Bts_MsgTransferSessionUpdate(); }
inline Ipc2Bts_MsgTransferNameUpdate* ptrNew_Ipc2Bts_MsgTransferNameUpdate(void) { return new Ipc2Bts_MsgTransferNameUpdate(); }
inline Ipc2Bts_MsgTransferTypeUpdate* ptrNew_Ipc2Bts_MsgTransferTypeUpdate(void) { return new Ipc2Bts_MsgTransferTypeUpdate(); }
inline Ipc2Bts_MsgTransferTimeUpdate* ptrNew_Ipc2Bts_MsgTransferTimeUpdate(void) { return new Ipc2Bts_MsgTransferTimeUpdate(); }
inline Ipc2Bts_MsgTransferSizeUpdate* ptrNew_Ipc2Bts_MsgTransferSizeUpdate(void) { return new Ipc2Bts_MsgTransferSizeUpdate(); }
inline Ipc2Bts_MsgTransferTransferredUpdate* ptrNew_Ipc2Bts_MsgTransferTransferredUpdate(void) { return new Ipc2Bts_MsgTransferTransferredUpdate(); }
inline Ipc2Bts_MsgTransferFilenameUpdate* ptrNew_Ipc2Bts_MsgTransferFilenameUpdate(void) { return new Ipc2Bts_MsgTransferFilenameUpdate(); }
inline Ipc2Bts_ServiceAvailabilityMediaPlayer* ptrNew_Ipc2Bts_ServiceAvailabilityMediaPlayer(void) { return new Ipc2Bts_ServiceAvailabilityMediaPlayer(); }

} //genivi
} //btstackif

#endif //_IPC_2_BTS_MESSAGE_WRAPPER_GENIVI_H_
